/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.MessageListener;

public class MessagingAccessLayer {
    private final String name;
    private final EnumMap<Bus, BusAccess> busAccesses = new EnumMap(Bus.class);

    public MessagingAccessLayer(String name, BusAccess ... buses) {
        this.name = name;
        for (BusAccess busAccess : buses) {
            this.busAccesses.put(busAccess.getBus(), busAccess);
        }
    }

    public String getName() {
        return this.name;
    }

    public Collection<BusAccess> getBusAccesses() {
        return this.busAccesses.values();
    }

    public BusAccess getBusAccess(Bus bus) {
        return this.busAccesses.get(bus);
    }

    public static abstract class StatusBusAccess
    extends BusAccess<StatusMessage> {
        public StatusBusAccess() {
            super(Bus.STATUS);
        }

        public abstract void processDisconnectionSuspicion(String var1);

        public abstract void processAnormalEvent(Exception var1);
    }

    public static class BusAccess<T extends BusMessage> {
        private final Map<MessageListener, BusMessageForwarder> forwarderMap = Collections.synchronizedMap(new LinkedHashMap());
        private final Bus bus;

        public BusAccess(Bus bus) {
            this.bus = bus;
        }

        public Bus getBus() {
            return this.bus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processBusMessage(T message) {
            Map<MessageListener, BusMessageForwarder> map = this.forwarderMap;
            synchronized (map) {
                Iterator<BusMessageForwarder> i = this.forwarderMap.values().iterator();
                while (i.hasNext()) {
                    i.next().update(message);
                }
            }
        }

        public void addForwarder(MessageListener l, BusMessageForwarder forwarder) {
            this.forwarderMap.put(l, forwarder);
        }

        public void removeForwarder(MessageListener l) {
            this.forwarderMap.remove(l);
        }

        public void processClusterDeserializationError(String address) {
        }
    }
}

