package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.data.AgentInfo;

/**
 * Agents that implement this interface are notified when an agent is connecting
 * or has disconnected on the status bus
 * 
 * @author emarin
 */
public interface AgentPresenceListener {
    
    /**
     * Indicates that the agent represented by {@code agent} is present on the
     * buses.
     * 
     * The implementation should return immediately : any blocking operations
     * should be scheduled on a separate thread.
     * 
     * @param agent 
     */
    public void connecting(AgentInfo agent);
    
    /**
     * Indicates that the agent represented by {@code agent} has left the buses.
     * 
     * The implementation should return immediately : any blocking operations
     * should be scheduled on a separate thread.
     * @param agent 
     */
    public void disconnecting(AgentInfo agent);
    
}
