package org.lsst.ccs.messaging;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

import org.lsst.ccs.utilities.logging.Logger;

public class NetworkUtilities {

    public static NetworkUtilities instance = new NetworkUtilities();

    NetworkInterface loopbackInterface = null;
    NetworkInterface mainInterface = null;

    private static final Logger log = Logger
            .getLogger("org.lsst.ccs.bus.layer");

    public NetworkUtilities() {
        Enumeration<NetworkInterface> i;
        try {
            i = NetworkInterface.getNetworkInterfaces();
            while (i.hasMoreElements()) {
                NetworkInterface n = i.nextElement();
                try {
                    boolean lb = n.isLoopback();
                    boolean up = n.isUp();
                    boolean mc = n.supportsMulticast();
                    boolean ipv4 = false;
                    boolean ipv6 = false;
                    for (InterfaceAddress a : n.getInterfaceAddresses()) {
                        InetAddress ad = a.getAddress();
                        if (ad instanceof Inet4Address)
                            ipv4 = true;
                        if (ad instanceof Inet6Address)
                            ipv6 = true;
                    }
                    if (lb)
                        loopbackInterface = n;
                    if (up && mc && ipv4 && ipv6 && !lb)
                        mainInterface = n;
                    if (mainInterface == null && up && mc && ipv4 && !lb)
                        mainInterface = n;
                } catch (SocketException e) {
                    log.error(
                            "Issue working with network interface "
                                    + n.getName(), e);
                }
            }
        } catch (SocketException e) {
            log.error("Cannot get network interfaces", e);
            throw new RuntimeException(e);
        }
    }

    public static String getLoopbackInterfaceName() {
        return instance.loopbackInterface.getName();
    }

    public static String getMainInterfaceName() {
        return instance.mainInterface.getName();
    }

}
