/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.bus;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.bus.AlarmBusMessage;
import org.lsst.ccs.messaging.bus.BaseBusMessage;
import org.lsst.ccs.messaging.bus.StatusBusMessage;
import org.lsst.ccs.messaging.bus.SuperAlarmBusMessage;

public class TestBusMessageFilter {
    @Test
    public void testBasicFiltering() {
        BaseBusMessage busMessage = new BaseBusMessage("This is the summary: temp");
        busMessage.setOriginAgentInfo(new AgentInfo("someOrigin", AgentInfo.AgentType.CONSOLE));
        AlarmBusMessage alarmMessage = new AlarmBusMessage("[ALARM] out of value: temp");
        alarmMessage.setOriginAgentInfo(new AgentInfo("someOtherOrigin", AgentInfo.AgentType.CONSOLE));
        SuperAlarmBusMessage superAlarmMessage = new SuperAlarmBusMessage("[ALARM] really out of value: temp");
        superAlarmMessage.setOriginAgentInfo(new AgentInfo("somewhereElseOrigin", AgentInfo.AgentType.CONSOLE));
        StatusBusMessage statusMessage = new StatusBusMessage("[STATUS] ");
        statusMessage.setOriginAgentInfo(new AgentInfo("ccc", AgentInfo.AgentType.CONSOLE));
        BusMessageFilter originFilter = BusMessageFilter.messageOrigin((String)"someOrigin");
        BusMessageFilter otherOriginFilter = BusMessageFilter.messageOrigin((String)"someOtherOrigin");
        BusMessageFilter notOtherOriginFilter = otherOriginFilter.negate();
        Assert.assertTrue((boolean)originFilter.accept((BusMessage)busMessage));
        Assert.assertTrue((boolean)otherOriginFilter.accept((BusMessage)alarmMessage));
        Assert.assertFalse((boolean)otherOriginFilter.accept((BusMessage)busMessage));
        Assert.assertTrue((boolean)notOtherOriginFilter.accept((BusMessage)busMessage));
        BusMessageFilter busMessageFilter = BusMessageFilter.messageClass(BaseBusMessage.class);
        BusMessageFilter alarmMessageFilter = BusMessageFilter.messageClass(AlarmBusMessage.class);
        BusMessageFilter superAlarmMessageFilter = BusMessageFilter.messageClass(SuperAlarmBusMessage.class);
        BusMessageFilter statusMessageFilter = BusMessageFilter.messageClass(StatusBusMessage.class);
        Assert.assertTrue((boolean)busMessageFilter.accept((BusMessage)busMessage));
        Assert.assertTrue((boolean)busMessageFilter.accept((BusMessage)alarmMessage));
        Assert.assertTrue((boolean)busMessageFilter.accept((BusMessage)superAlarmMessage));
        Assert.assertTrue((boolean)busMessageFilter.accept((BusMessage)statusMessage));
        Assert.assertFalse((boolean)alarmMessageFilter.accept((BusMessage)busMessage));
        Assert.assertTrue((boolean)alarmMessageFilter.accept((BusMessage)alarmMessage));
        Assert.assertTrue((boolean)alarmMessageFilter.accept((BusMessage)superAlarmMessage));
        Assert.assertFalse((boolean)alarmMessageFilter.accept((BusMessage)statusMessage));
        Assert.assertFalse((boolean)superAlarmMessageFilter.accept((BusMessage)busMessage));
        Assert.assertFalse((boolean)superAlarmMessageFilter.accept((BusMessage)alarmMessage));
        Assert.assertTrue((boolean)superAlarmMessageFilter.accept((BusMessage)superAlarmMessage));
        Assert.assertFalse((boolean)superAlarmMessageFilter.accept((BusMessage)statusMessage));
        Assert.assertFalse((boolean)statusMessageFilter.accept((BusMessage)busMessage));
        Assert.assertFalse((boolean)statusMessageFilter.accept((BusMessage)alarmMessage));
        Assert.assertFalse((boolean)statusMessageFilter.accept((BusMessage)superAlarmMessage));
        Assert.assertTrue((boolean)statusMessageFilter.accept((BusMessage)statusMessage));
        final String summaryFilter = "temp";
        BusMessageFilter summaryfilter = new BusMessageFilter(){

            protected boolean internalAccept(BusMessage busMessage) {
                if (busMessage instanceof BaseBusMessage) {
                    return ((BaseBusMessage)busMessage).getSummary().contains(summaryFilter);
                }
                return false;
            }

            protected String internalToString() {
                return "";
            }
        };
        BusMessageFilter notTempSummaryFilter = summaryfilter.negate();
        Assert.assertTrue((boolean)summaryfilter.accept((BusMessage)busMessage));
        Assert.assertTrue((boolean)summaryfilter.accept((BusMessage)alarmMessage));
        Assert.assertTrue((boolean)summaryfilter.accept((BusMessage)superAlarmMessage));
        Assert.assertFalse((boolean)summaryfilter.accept((BusMessage)statusMessage));
        Assert.assertFalse((boolean)notTempSummaryFilter.accept((BusMessage)busMessage));
        Assert.assertFalse((boolean)notTempSummaryFilter.accept((BusMessage)alarmMessage));
        Assert.assertFalse((boolean)notTempSummaryFilter.accept((BusMessage)superAlarmMessage));
        Assert.assertTrue((boolean)notTempSummaryFilter.accept((BusMessage)statusMessage));
    }

    @Test
    public void testCompositeFiltering() {
        BaseBusMessage busMessage = new BaseBusMessage("This is the summary: temp");
        busMessage.setOriginAgentInfo(new AgentInfo("someOrigin", AgentInfo.AgentType.CONSOLE));
        AlarmBusMessage alarmMessage = new AlarmBusMessage("[ALARM] out of value: temp");
        alarmMessage.setOriginAgentInfo(new AgentInfo("someOtherOrigin", AgentInfo.AgentType.CONSOLE));
        SuperAlarmBusMessage superAlarmMessage = new SuperAlarmBusMessage("[ALARM] really out of value: temp");
        superAlarmMessage.setOriginAgentInfo(new AgentInfo("somewhereElseOrigin", AgentInfo.AgentType.CONSOLE));
        StatusBusMessage statusMessage = new StatusBusMessage("[STATUS] ");
        statusMessage.setOriginAgentInfo(new AgentInfo("ccc", AgentInfo.AgentType.CONSOLE));
        BusMessageFilter twoOriginFilter = BusMessageFilter.messageOrigin((String)"someOrigin").or(BusMessageFilter.messageOrigin((String)"someOtherOrigin"));
        BusMessageFilter notFromTwoOriginFilter = BusMessageFilter.messageOrigin((String)"ccc").negate().and(BusMessageFilter.messageOrigin((String)"someOtherOrigin").negate());
        BusMessageFilter fromAnywhereFilter = BusMessageFilter.messageOrigin((String)"ccc").negate().or(BusMessageFilter.messageOrigin((String)"someOtherOrigin").negate());
        Assert.assertTrue((boolean)twoOriginFilter.accept((BusMessage)busMessage));
        Assert.assertTrue((boolean)twoOriginFilter.accept((BusMessage)alarmMessage));
        Assert.assertFalse((boolean)twoOriginFilter.accept((BusMessage)superAlarmMessage));
        Assert.assertFalse((boolean)twoOriginFilter.accept((BusMessage)statusMessage));
        Assert.assertTrue((boolean)notFromTwoOriginFilter.accept((BusMessage)busMessage));
        Assert.assertFalse((boolean)notFromTwoOriginFilter.accept((BusMessage)alarmMessage));
        Assert.assertTrue((boolean)notFromTwoOriginFilter.accept((BusMessage)superAlarmMessage));
        Assert.assertFalse((boolean)notFromTwoOriginFilter.accept((BusMessage)statusMessage));
        Assert.assertTrue((boolean)fromAnywhereFilter.accept((BusMessage)busMessage));
        Assert.assertTrue((boolean)fromAnywhereFilter.accept((BusMessage)alarmMessage));
        Assert.assertTrue((boolean)fromAnywhereFilter.accept((BusMessage)superAlarmMessage));
        Assert.assertTrue((boolean)fromAnywhereFilter.accept((BusMessage)statusMessage));
        BusMessageFilter onlyAlarmsFromAnOrigin = BusMessageFilter.messageOrigin((String)"someOtherOrigin").and(BusMessageFilter.messageClass(AlarmBusMessage.class));
        Assert.assertFalse((boolean)onlyAlarmsFromAnOrigin.accept((BusMessage)busMessage));
        Assert.assertTrue((boolean)onlyAlarmsFromAnOrigin.accept((BusMessage)alarmMessage));
        Assert.assertFalse((boolean)onlyAlarmsFromAnOrigin.accept((BusMessage)superAlarmMessage));
        Assert.assertFalse((boolean)onlyAlarmsFromAnOrigin.accept((BusMessage)statusMessage));
    }
}

