/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.CommandRejectedException;
import org.lsst.ccs.messaging.StatusMessageListener;

public final class ConcurrentMessagingUtils {
    private final AgentMessagingLayer agentMessagingLayer;
    private static final Object NULL = new Object();
    private Duration defaultTimeout = null;

    public ConcurrentMessagingUtils(AgentMessagingLayer agentMessagingLayer) {
        this(agentMessagingLayer, Duration.ofSeconds(5L));
    }

    public ConcurrentMessagingUtils(AgentMessagingLayer agentMessagingLayer, Duration defaultTimeout) {
        this.agentMessagingLayer = agentMessagingLayer;
        this.defaultTimeout = defaultTimeout;
    }

    public void setDefaultTimeout(Duration defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public Duration getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public Object sendSynchronousCommand(CommandRequest command) throws Exception {
        return this.invokeIt(false, command, this.defaultTimeout, false);
    }

    @Deprecated
    public Object sendSynchronousCommand(CommandRequest command, long millisTimeout) throws Exception {
        return this.invokeIt(false, command, Duration.ofMillis(millisTimeout), true);
    }

    public Object sendSynchronousCommand(CommandRequest command, Duration timeout) throws Exception {
        return this.invokeIt(false, command, timeout, true);
    }

    public Future<Object> sendAsynchronousCommand(CommandRequest command) {
        LinkedCommandOriginator commandOriginator = new LinkedCommandOriginator(false, this.agentMessagingLayer);
        LinkedFuture<Object> linkedFuture = new LinkedFuture<Object>(commandOriginator, false);
        linkedFuture.init();
        this.agentMessagingLayer.sendCommandRequest(command, commandOriginator);
        return linkedFuture;
    }

    @Deprecated
    public Object getAckForCommand(CommandRequest command, long millisTimeout) throws Exception {
        return this.invokeIt(true, command, Duration.ofMillis(millisTimeout), true);
    }

    public Object getAckForCommand(CommandRequest command, Duration timeout) throws Exception {
        return this.invokeIt(true, command, timeout, true);
    }

    private Object invokeIt(boolean ackOnly, CommandRequest command, Duration timeout, boolean isTimeoutUserProvided) throws Exception {
        long timeoutMillis = 0L;
        TimeUnit timeoutUnits = TimeUnit.MILLISECONDS;
        if (timeout == null) {
            if (isTimeoutUserProvided) {
                throw new IllegalArgumentException("Provided timeout cannot be null");
            }
            timeoutMillis = -1L;
        } else {
            timeoutMillis = timeout.toMillis();
        }
        LinkedCommandOriginator commandOriginator = new LinkedCommandOriginator(ackOnly, this.agentMessagingLayer);
        SynchLinkedFuture<Object> linkedFuture = new SynchLinkedFuture<Object>(commandOriginator, false, isTimeoutUserProvided);
        linkedFuture.init();
        this.agentMessagingLayer.sendCommandRequest(command, commandOriginator);
        Object res = null;
        res = linkedFuture.get(timeoutMillis, timeoutUnits);
        if (res instanceof Exception) {
            throw (Exception)res;
        }
        return res;
    }

    @Deprecated
    public Future<StatusMessage> startListeningForStatusBusMessage(Predicate<BusMessage<? extends Serializable, ?>> filter, long timeout) {
        LinkedStatusBusListener innerListener = new LinkedStatusBusListener(filter, timeout, this.agentMessagingLayer);
        LinkedFuture<StatusMessage> future = new LinkedFuture<StatusMessage>(innerListener, true);
        future.init();
        this.agentMessagingLayer.addStatusMessageListener(innerListener, filter);
        return future;
    }

    public Future<StatusMessage> startListeningForStatusBusMessage(Predicate<BusMessage<? extends Serializable, ?>> filter, Duration timeout) {
        LinkedStatusBusListener innerListener = new LinkedStatusBusListener(filter, timeout.toMillis(), this.agentMessagingLayer);
        LinkedFuture<StatusMessage> future = new LinkedFuture<StatusMessage>(innerListener, true);
        future.init();
        this.agentMessagingLayer.addStatusMessageListener(innerListener, filter);
        return future;
    }

    public Future<StatusMessage> startListeningForStatusBusMessage(Predicate<BusMessage<? extends Serializable, ?>> f) {
        return this.startListeningForStatusBusMessage(f, Duration.ofMillis(-1L));
    }

    class SynchLinkedFuture<T>
    extends LinkedFuture {
        private final boolean isTimeoutUserProvided;

        SynchLinkedFuture(LinkedTask<T> task, boolean throwException, boolean isTimeoutUserProvided) {
            super(task, throwException);
            this.isTimeoutUserProvided = isTimeoutUserProvided;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long pollTimeout = timeout;
            TimeUnit pollTimeUnit = unit;
            if (!this.isTimeoutUserProvided) {
                long start = System.currentTimeMillis();
                Duration internalTaskDuration = this.task.getTaskInternalTimeout();
                if (internalTaskDuration != null) {
                    pollTimeout = internalTaskDuration.toMillis();
                    pollTimeUnit = TimeUnit.MILLISECONDS;
                }
                pollTimeout -= System.currentTimeMillis() - start;
            }
            return super.get(pollTimeout, pollTimeUnit);
        }
    }

    class LinkedFuture<T>
    implements Future<T> {
        private final LinkedTransferQueue<Object> queue = new LinkedTransferQueue();
        protected final LinkedTask<T> task;
        private boolean isCancelled = false;
        private final boolean throwException;
        private boolean initialized = false;

        LinkedFuture(LinkedTask<T> task, boolean throwException) {
            this.task = task;
            this.throwException = throwException;
        }

        protected void init() {
            if (this.initialized) {
                throw new RuntimeException("LinkedFuture must be initialized only once");
            }
            this.initialized = true;
            this.task.setLinkedFuture(this);
        }

        @Override
        public boolean isCancelled() {
            if (!this.initialized) {
                throw new RuntimeException("LinkedFuture must be initialized first");
            }
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            if (!this.initialized) {
                throw new RuntimeException("LinkedFuture must be initialized first");
            }
            return !this.queue.isEmpty();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.initialized) {
                throw new RuntimeException("LinkedFuture must be initialized first");
            }
            if (!this.isCancelled) {
                this.task.cancel();
                this.isCancelled = true;
            }
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (!this.initialized) {
                throw new RuntimeException("LinkedFuture must be initialized first");
            }
            return this.processReply(this.queue.take());
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.initialized) {
                throw new RuntimeException("LinkedFuture must be initialized first");
            }
            Object reply = this.queue.poll(timeout, unit);
            if (reply == null) {
                throw new TimeoutException("Could not get reply within the specified timeout of " + timeout + " " + unit.toString());
            }
            return this.processReply(reply);
        }

        private T processReply(Object reply) throws InterruptedException, ExecutionException {
            if (!this.initialized) {
                throw new RuntimeException("LinkedFuture must be initialized first");
            }
            if (reply instanceof Exception && this.throwException) {
                throw new ExecutionException("Execution Exception", (Exception)reply);
            }
            return (T)(reply != NULL ? reply : null);
        }

        void addToQueue(Object obj) {
            if (!this.initialized) {
                throw new RuntimeException("LinkedFuture must be initialized first");
            }
            if (obj == null) {
                obj = NULL;
            }
            this.queue.offer(obj);
            this.task.stop();
        }
    }

    abstract class LinkedTask<T> {
        LinkedFuture<T> future = null;

        LinkedTask() {
        }

        public abstract void cancel();

        public abstract void start();

        public abstract void stop();

        public abstract Duration getTaskInternalTimeout();

        void setLinkedFuture(LinkedFuture<T> future) {
            this.future = future;
            this.start();
        }

        LinkedFuture<T> getLinkedFuture() {
            return this.future;
        }
    }

    private class LinkedCommandOriginator
    extends LinkedTask<Object>
    implements CommandOriginator {
        private final boolean getAckOnly;
        private volatile Duration timeout = null;
        private boolean gotAck = false;
        private final Object ackLock = new Object();

        LinkedCommandOriginator(boolean ackOnly, AgentMessagingLayer agentMessagingLayer) {
            this.getAckOnly = ackOnly;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Duration getTaskInternalTimeout() {
            try {
                Object object = this.ackLock;
                synchronized (object) {
                    if (!this.gotAck) {
                        this.ackLock.wait();
                    }
                }
                return this.timeout;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Problem getting task internal timeout ", ie);
            }
        }

        @Override
        public void processNack(CommandNack nack) {
            CommandRejectedException rejection = new CommandRejectedException(nack);
            this.getLinkedFuture().addToQueue(rejection);
        }

        @Override
        public void processResult(CommandResult result) {
            Object resultContent;
            if (this.getAckOnly) {
                return;
            }
            try {
                resultContent = result.getResult();
            }
            catch (Exception e) {
                resultContent = result.getEncodedData();
            }
            this.getLinkedFuture().addToQueue(resultContent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processAck(CommandAck ack) {
            Object object = this.ackLock;
            synchronized (object) {
                this.timeout = ack.getTimeout();
                this.gotAck = true;
                this.ackLock.notifyAll();
            }
            if (this.getAckOnly) {
                this.getLinkedFuture().addToQueue(ack);
            }
        }
    }

    class LinkedStatusBusListener
    extends LinkedTask<StatusMessage>
    implements StatusMessageListener {
        private final Predicate<BusMessage<? extends Serializable, ?>> filter;
        private final Timer timeoutTimer = new Timer("LinkedStatusBusListener");
        private boolean cleanedUp = false;
        private final AgentMessagingLayer agentMessagingLayer;
        private final long timeout;

        LinkedStatusBusListener(Predicate<BusMessage<? extends Serializable, ?>> filter, long timeout, AgentMessagingLayer agentMessagingLayer) {
            this.filter = filter;
            this.agentMessagingLayer = agentMessagingLayer;
            this.timeout = timeout;
        }

        @Override
        public void start() {
            if (this.timeout > 0L) {
                this.timeoutTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        this.cancel();
                        TimeoutException ex = new TimeoutException("Timeout listening for filtered events " + LinkedStatusBusListener.this.filter.toString());
                        LinkedStatusBusListener.this.getLinkedFuture().addToQueue(ex);
                    }
                }, this.timeout);
            }
        }

        @Override
        public Duration getTaskInternalTimeout() {
            return null;
        }

        @Override
        public void stop() {
            this.cancel();
        }

        @Override
        public void cancel() {
            if (!this.cleanedUp) {
                this.agentMessagingLayer.removeStatusMessageListener(this);
                this.cleanedUp = true;
            }
        }

        @Override
        public void onStatusMessage(StatusMessage bm) {
            if (!this.getLinkedFuture().isDone()) {
                this.timeoutTimer.cancel();
                this.getLinkedFuture().addToQueue(bm);
            }
        }
    }
}

