package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.messages.StatusMessage;

/**
 * Interface to be implemented by listeners that wish to be notified of messages
 * received on the status bus.
 *
 * @author emarin
 */
public interface StatusMessageListener extends MessageListener {

    /**
     * Called when the message is received.
     * The implementation should be thread-safe: the framework makes no guarantees
     * on what thread this method will be called on, and it can be called concurrently
     * for several messages.
     * 
     * @param msg Status bus message to be processed.
     */
    void onStatusMessage(StatusMessage msg);
}
