/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class StateBundleAggregator
implements StatusMessageListener {
    static Logger log = Logger.getLogger((String)"lsst.ccs.bus");
    Set<String> origins = new HashSet<String>();
    Map<String, StateBundle> states = new ConcurrentHashMap<String, StateBundle>();
    ArrayList<Observer> observers = new ArrayList();

    public void addOrigin(String origin) {
        this.origins.add(origin);
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
        String origin = msg.getOriginAgentInfo().getName();
        if (!this.origins.contains(origin)) {
            return;
        }
        StateBundle bundle = msg.getState();
        StateBundle oldBundle = this.states.get(origin);
        if (oldBundle != null) {
            bundle = oldBundle.mergeState(bundle);
        }
        this.states.put(origin, bundle);
        if (oldBundle != null && !oldBundle.equals((Object)bundle)) {
            StateBundle diff = bundle.diffState(oldBundle);
            log.debug((Object)("state of " + origin + " changed : " + diff));
            this.notifyObservers(origin, diff);
        }
    }

    public synchronized void addObserver(Observer o) {
        this.observers.add(o);
    }

    public synchronized void deleteObserver(Observer o) {
        this.observers.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(String origin, StateBundle change) {
        ArrayList<Observer> obs;
        StateBundleAggregator stateBundleAggregator = this;
        synchronized (stateBundleAggregator) {
            obs = new ArrayList<Observer>(this.observers);
        }
        for (Observer o : obs) {
            o.stateChanged(origin, change);
        }
    }

    public StateBundle getState(String origin) {
        return this.states.get(origin);
    }

    public Map<String, StateBundle> getStates() {
        return Collections.unmodifiableMap(this.states);
    }

    public static interface Observer {
        public void stateChanged(String var1, StateBundle var2);
    }
}

