package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.data.AgentInfo;

/**
 * Agents that implement this interface are notified when an agent is connecting
 * or has disconnected on the status bus
 * 
 * @author emarin
 */
public interface AgentPresenceListener {
    
    //TODO: Remove default implementation when org.lsst.ccs.bus.messages.AgentInfo is removed
    default public void connecting(AgentInfo agent) {
        connecting( (org.lsst.ccs.bus.messages.AgentInfo)agent);
    }
    
    //TODO: Remove default implementation when org.lsst.ccs.bus.messages.AgentInfo is removed
    default public void disconnecting(AgentInfo agent) {
        disconnecting( (org.lsst.ccs.bus.messages.AgentInfo)agent);        
    }
    
    @Deprecated
    default public void connecting(org.lsst.ccs.bus.messages.AgentInfo agent) {
        
    }
    
    @Deprecated
    default public void disconnecting(org.lsst.ccs.bus.messages.AgentInfo agent) {
        
    }
}
