/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.MessageListener;

public class MessagingAccessLayer {
    private final String name;
    private HashMap<Bus, BusAccess> busAccesses = new HashMap();

    public MessagingAccessLayer(String name, Bus ... buses) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<BusAccess> getBusAccesses() {
        return this.busAccesses.values();
    }

    public BusAccess getBusAccess(Bus bus) {
        return this.busAccesses.get(bus);
    }

    public void addBusAccess(BusAccess busAccess) {
        this.busAccesses.put(busAccess.getBus(), busAccess);
    }

    public static class BusAccess<T extends BusMessage> {
        private final ConcurrentHashMap<MessageListener, BusMessageForwarder> forwarderMap = new ConcurrentHashMap();
        private Bus<T> bus;

        public BusAccess(Bus bus) {
            this.bus = bus;
        }

        public Bus<T> getBus() {
            return this.bus;
        }

        public void processBusMessage(T message) {
        }

        public void addForwarder(MessageListener l, BusMessageForwarder forwarder) {
            this.forwarderMap.put(l, forwarder);
        }

        public void removeForwarder(MessageListener l) {
            this.forwarderMap.remove(l);
        }

        public ArrayList<BusMessageForwarder> getForwarderList() {
            return new ArrayList<BusMessageForwarder>(this.forwarderMap.values());
        }
    }

    public static abstract class StatusBusAccess
    extends BusAccess<StatusMessage> {
        public StatusBusAccess(Bus<StatusMessage> bus) {
            super(bus);
        }

        public abstract void processDisconnectionSuspicion(String var1);

        public abstract void processAnormalEvent(Exception var1);
    }
}

