package org.lsst.ccs.messaging;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;


/**
 * A Class to keep track of MessagingAccesses, BusApplicationLayers and BusMessagingLayers.
 * 
 * @author turri
 */
class MessagingAccessManager {
    
    private final static List<AgentMessagingLayer> msgAccesses = new CopyOnWriteArrayList<>();

    static void addMessagingAccess(AgentMessagingLayer msgFact) {
        msgAccesses.add(msgFact);
    }
        
    static void removeMessagingAccess(AgentMessagingLayer msgFact) {
        msgAccesses.remove(msgFact);
    }
    
    static List<AgentMessagingLayer> getMessagingAccesses() {
        return msgAccesses;        
    }        
    
    static void printMessagingAccessInfo(AgentMessagingLayer msgAccess) {
        System.out.println("MessagingAccess "+msgAccess.getAgentName());
        BusApplicationLayer layer = msgAccess.getApplicationLayer();
        System.out.println("BusApplicationLayer "+layer);        
        BusMessagingLayer messagingLayer = layer.getBusMessagingLayer();
        System.out.println("BusMessagingLayer "+messagingLayer);        
        Set<String> localAgents = messagingLayer.getRegisteredLocalAgents();
        System.out.println("Local Agents "+localAgents.size()); 
        for ( String agent: localAgents ) {
            System.out.println("\t"+agent);
        }
    }
    
}
