/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.messaging.StatusAggregator;

public class StatusAggregatorTest {
    @Test
    public void testAgregator() {
        double av;
        System.out.println("testing status agregator");
        StatusAggregator sa = new StatusAggregator();
        sa.setAggregate("sys1/val1", -1, -1);
        sa.setAggregate("sys1/val2", 100, -1);
        sa.setAggregate("sys2/val1", -1, 200);
        sa.setAggregate("sys3/val1", 50, 300);
        sa.setAggregate("sys3/val2", 300, 50);
        int i = 0;
        while (i < 10000) {
            sa.onKeyValueStatusDecomposition("sys1", (long)i, "val1", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys1", (long)i, "val2", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys2", (long)i, "val1", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys3", (long)i, "val1", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys3", (long)i, "val2", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys4", (long)i, "val1", (Object)Math.sin(i), 555);
            ++i;
        }
        Assert.assertEquals((String)"sys1/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys1/val1")), (double)0.001);
        Assert.assertEquals((String)"sys1/val2 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys1/val2")), (double)0.001);
        Assert.assertEquals((String)"sys2/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys2/val1")), (double)0.001);
        Assert.assertEquals((String)"sys3/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys3/val1")), (double)0.001);
        Assert.assertEquals((String)"sys3/val2 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys3/val2")), (double)0.001);
        Assert.assertNull((String)"sys4/val1 null", (Object)sa.getLast("sys4/val1"));
        List l = sa.getHistory("sys1/val1");
        Assert.assertNull((String)"sys1/val1 history", (Object)l);
        l = sa.getHistory("sys1/val2");
        Assert.assertEquals((String)"sys1/val2 history start", (long)9899L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys2/val1");
        Assert.assertNull((String)"sys2/val1 history", (Object)l);
        l = sa.getHistory("sys3/val1");
        Assert.assertEquals((String)"sys3/val1 history start", (long)9949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys3/val2");
        Assert.assertEquals((String)"sys3/val2 history start", (long)9699L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        try {
            av = sa.getAverage("sys1/val1");
            System.out.println("sys1/val1 average " + av);
            Assert.fail((String)"sys1/val1 aggregate should throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {}
        try {
            av = sa.getAverage("sys1/val2");
            System.out.println("sys1/val2 average " + av);
            Assert.fail((String)"sys1/val2 aggregate should throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {}
        double s = 0.0;
        double mx = -1.7976931348623157E308;
        double mn = Double.MAX_VALUE;
        int i2 = 9799;
        while (i2 < 10000) {
            s += Math.sin(i2);
            if (mx < Math.sin(i2)) {
                mx = Math.sin(i2);
            }
            if (mn > Math.sin(i2)) {
                mn = Math.sin(i2);
            }
            ++i2;
        }
        Assert.assertEquals((String)"sys2/val1 average", (double)(s /= 201.0), (double)sa.getAverage("sys2/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys2/val1 min", (double)mn, (double)sa.getMin("sys2/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys2/val1 max", (double)mx, (double)sa.getMax("sys2/val1"), (double)1.0E-7);
        s = 0.0;
        mx = -1.7976931348623157E308;
        mn = Double.MAX_VALUE;
        i2 = 9699;
        while (i2 < 10000) {
            s += Math.sin(i2);
            if (mx < Math.sin(i2)) {
                mx = Math.sin(i2);
            }
            if (mn > Math.sin(i2)) {
                mn = Math.sin(i2);
            }
            ++i2;
        }
        Assert.assertEquals((String)"sys3/val1 average", (double)(s /= 301.0), (double)sa.getAverage("sys3/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val1 min", (double)mn, (double)sa.getMin("sys3/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val1 max", (double)mx, (double)sa.getMax("sys3/val1"), (double)1.0E-7);
        s = 0.0;
        mx = -1.7976931348623157E308;
        mn = Double.MAX_VALUE;
        i2 = 9949;
        while (i2 < 10000) {
            s += Math.sin(i2);
            if (mx < Math.sin(i2)) {
                mx = Math.sin(i2);
            }
            if (mn > Math.sin(i2)) {
                mn = Math.sin(i2);
            }
            ++i2;
        }
        Assert.assertEquals((String)"sys3/val2 average", (double)(s /= 51.0), (double)sa.getAverage("sys3/val2"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val2 min", (double)mn, (double)sa.getMin("sys3/val2"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val2 max", (double)mx, (double)sa.getMax("sys3/val2"), (double)1.0E-7);
    }

    @Test
    public void testAgregatorPattern() {
        System.out.println("testing status agregator with patterns");
        StatusAggregator sa = new StatusAggregator();
        sa.setAggregatePattern("sys[1-3]/val.", 50, 300);
        int i = 0;
        while (i < 10000) {
            sa.onKeyValueStatusDecomposition("sys1", (long)i, "val1", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys1", (long)i, "val2", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys2", (long)i, "val1", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys3", (long)i, "val1", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys3", (long)i, "val2", (Object)Math.sin(i), 555);
            sa.onKeyValueStatusDecomposition("sys4", (long)i, "val1", (Object)Math.sin(i), 555);
            ++i;
        }
        Assert.assertEquals((String)"sys1/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys1/val1")), (double)0.001);
        Assert.assertEquals((String)"sys1/val2 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys1/val2")), (double)0.001);
        Assert.assertEquals((String)"sys2/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys2/val1")), (double)0.001);
        Assert.assertEquals((String)"sys3/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys3/val1")), (double)0.001);
        Assert.assertEquals((String)"sys3/val2 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys3/val2")), (double)0.001);
        Assert.assertNull((String)"sys4/val1 null", (Object)sa.getLast("sys4/val1"));
        List l = sa.getHistory("sys1/val1");
        Assert.assertEquals((String)"sys1/val1 history start", (long)9949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys1/val2");
        Assert.assertEquals((String)"sys1/val2 history start", (long)9949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys2/val1");
        Assert.assertEquals((String)"sys2/val1 history start", (long)9949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys3/val1");
        Assert.assertEquals((String)"sys3/val1 history start", (long)9949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys3/val2");
        Assert.assertEquals((String)"sys3/val2 history start", (long)9949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        double s = 0.0;
        double mx = -1.7976931348623157E308;
        double mn = Double.MAX_VALUE;
        int i2 = 9699;
        while (i2 < 10000) {
            s += Math.sin(i2);
            if (mx < Math.sin(i2)) {
                mx = Math.sin(i2);
            }
            if (mn > Math.sin(i2)) {
                mn = Math.sin(i2);
            }
            ++i2;
        }
        Assert.assertEquals((String)"sys2/val1 average", (double)(s /= 301.0), (double)sa.getAverage("sys2/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys2/val1 min", (double)mn, (double)sa.getMin("sys2/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys2/val1 max", (double)mx, (double)sa.getMax("sys2/val1"), (double)1.0E-7);
        s = 0.0;
        mx = -1.7976931348623157E308;
        mn = Double.MAX_VALUE;
        i2 = 9699;
        while (i2 < 10000) {
            s += Math.sin(i2);
            if (mx < Math.sin(i2)) {
                mx = Math.sin(i2);
            }
            if (mn > Math.sin(i2)) {
                mn = Math.sin(i2);
            }
            ++i2;
        }
        Assert.assertEquals((String)"sys3/val1 average", (double)(s /= 301.0), (double)sa.getAverage("sys3/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val1 min", (double)mn, (double)sa.getMin("sys3/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val1 max", (double)mx, (double)sa.getMax("sys3/val1"), (double)1.0E-7);
        s = 0.0;
        mx = -1.7976931348623157E308;
        mn = Double.MAX_VALUE;
        i2 = 9699;
        while (i2 < 10000) {
            s += Math.sin(i2);
            if (mx < Math.sin(i2)) {
                mx = Math.sin(i2);
            }
            if (mn > Math.sin(i2)) {
                mn = Math.sin(i2);
            }
            ++i2;
        }
        Assert.assertEquals((String)"sys3/val2 average", (double)(s /= 301.0), (double)sa.getAverage("sys3/val2"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val2 min", (double)mn, (double)sa.getMin("sys3/val2"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val2 max", (double)mx, (double)sa.getMax("sys3/val2"), (double)1.0E-7);
    }
}

