package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.messages.StatusMessage;

/**
 * @author bamade
 */
// Date: 22/05/2014
public interface SerializedDataStatusListener extends EncodedStatusListens {

    /**
     * this method is called if an <TT>EncodedDataStatus</TT>
     * object is not decomposable, is Serializable and had been serialized in a byte array.
     *
     * @param timestamp
     * @param key
     * @param serializedData
     */
    void onSerializedDataArrival(String source, long timestamp, String key, byte[] serializedData);

    @Override
    default public void onStatusMessage(StatusMessage msg) {
      //  throw new RuntimeException("This method should be deleted and should not be invoked");
    }

}
