/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.EncodedDataStatus;
import org.lsst.ccs.bus.messages.KVList;
import org.lsst.ccs.bus.messages.KeyData;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.DataStatusListener;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.EncodedStatusListens;
import org.lsst.ccs.messaging.KeyValueStatusListener;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.messaging.ProvidesDisconnectionInformation;
import org.lsst.ccs.messaging.SerializedDataStatusListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.messaging.TransportException;
import org.lsst.ccs.messaging.TransportManager;
import org.lsst.ccs.utilities.logging.Logger;

class BusApplicationLayer {
    private final AgentInfo agentInfo;
    private final String subsystemName;
    private final BusMessagingLayer busMessagingLayer;
    private static Logger log = Logger.getLogger((String)"org.lsst.ccs.bus.layer");
    private final MessagingAccessLayer messagingAccessLayer;
    private final AgentPresenceManager agentPresenceManager;
    private final IdentityHashMap<CommandMessageListener, BusMessageForwarder> commandForwarderMap = new IdentityHashMap();
    private final IdentityHashMap<LogMessageListener, BusMessageForwarder> logForwarderMap = new IdentityHashMap();
    private final IdentityHashMap<StatusMessageListener, BusMessageForwarder> statusForwarderMap = new IdentityHashMap();
    private final ForwarderToCommandExecutor commandExecutorForwarder = new ForwarderToCommandExecutor();
    private final ForwarderToCommandOriginator commandOriginatorForwarder = new ForwarderToCommandOriginator();

    BusApplicationLayer(AgentInfo agentInfo) {
        String protocolProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport", "jgroups:udp_ccs:");
        String transportPropsProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport.properties", "");
        try {
            this.busMessagingLayer = TransportManager.getConnection(protocolProperty, transportPropsProperty);
        }
        catch (TransportException exc) {
            throw new RuntimeException(exc);
        }
        this.agentInfo = agentInfo;
        this.subsystemName = agentInfo.getName();
        this.messagingAccessLayer = new MessagingAccessLayer(this.subsystemName, new Bus[0]);
        this.agentPresenceManager = this.getBusMessagingLayer() instanceof ProvidesDisconnectionInformation ? new AgentPresenceManager(true) : new AgentPresenceManager(false);
        this.addStatusListener(this.agentPresenceManager, BusMessageFilter.messageOrigin(this.agentInfo.getName()).not());
        this.messagingAccessLayer.addBusAccess(new MessagingAccessLayer.BusAccess<LogMessage>(Bus.LOG){

            @Override
            public void processBusMessage(LogMessage message) {
                for (BusMessageForwarder forwarder : BusApplicationLayer.this.logForwarderMap.values()) {
                    forwarder.update(message);
                }
            }
        });
        this.messagingAccessLayer.addBusAccess(new MessagingAccessLayer.StatusBusAccess(Bus.STATUS){

            @Override
            public void processBusMessage(StatusMessage message) {
                for (BusMessageForwarder forwarder : BusApplicationLayer.this.statusForwarderMap.values()) {
                    forwarder.update(message);
                }
            }

            @Override
            public void processDisconnectionSuspicion(String address, String info) {
                if (BusApplicationLayer.this.getAgentPresenceManager() != null) {
                    BusApplicationLayer.this.getAgentPresenceManager().disconnecting(address, info);
                }
            }

            @Override
            public void processAnormalEvent(Exception ex) {
                if (BusApplicationLayer.this.agentPresenceManager != null) {
                    BusApplicationLayer.this.agentPresenceManager.anormalEvent(ex);
                }
            }
        });
        this.messagingAccessLayer.addBusAccess(new MessagingAccessLayer.BusAccess<CommandMessage>(Bus.COMMAND){

            @Override
            public void processBusMessage(CommandMessage message) {
                for (BusMessageForwarder forwarder : BusApplicationLayer.this.commandForwarderMap.values()) {
                    forwarder.update(message);
                }
                if (message instanceof CommandRequest) {
                    BusApplicationLayer.this.commandExecutorForwarder.update((CommandRequest)message);
                } else if (message instanceof CommandReply) {
                    BusApplicationLayer.this.commandOriginatorForwarder.update((CommandReply)message);
                }
            }
        });
        try {
            this.busMessagingLayer.connect(this.messagingAccessLayer);
        }
        catch (DuplicateAgentNameException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    final BusMessagingLayer getBusMessagingLayer() {
        return this.busMessagingLayer;
    }

    AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    protected String[] parseDestination(String destination) {
        String[] dests = destination.split(",");
        int ix = 0;
        while (ix < dests.length) {
            String dest = dests[ix];
            if ("*".equals(dest)) {
                dests = new String[]{};
                break;
            }
            if (dest.contains("/")) {
                dests[ix] = dest.substring(0, dest.indexOf("/"));
            }
            ++ix;
        }
        return dests;
    }

    void sendCommand(CommandRequest cmd, CommandOriginator originator) throws IOException {
        String originatorId = UUID.randomUUID().toString();
        cmd.setCommandOriginatorId(originatorId);
        this.commandOriginatorForwarder.addCommandOriginator(originatorId, originator);
        String[] destinations = this.parseDestination(cmd.getDestination());
        if (cmd.getOriginAgentInfo().getName() == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.COMMAND, cmd, destinations);
    }

    void sendStatus(StatusMessage status) throws IOException {
        String origin = status.getOriginAgentInfo().getName();
        if (origin == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.STATUS, status, new String[0]);
    }

    void sendLogEvent(LogMessage evt) throws IOException {
        String origin = evt.getOriginAgentInfo().getName();
        if (origin == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.LOG, evt, new String[0]);
    }

    void reply(CommandReply cmd) throws IOException {
        String origin = cmd.getOriginAgentInfo().getName();
        if (origin == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        String destination = cmd.getDestination();
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.COMMAND, cmd, destination);
    }

    void setCommandExecutor(CommandExecutor executor) {
        this.commandExecutorForwarder.setCommandExecutor(executor);
    }

    void removeCommandExecutor() {
        this.commandExecutorForwarder.removeCommandExecutor();
    }

    void addCommandListener(CommandMessageListener l, BusMessageFilter filter) {
        ForwarderToCommandListeners forwarder = new ForwarderToCommandListeners(l, filter);
        this.commandForwarderMap.put(l, forwarder);
    }

    void removeCommandListener(CommandMessageListener l) {
        this.commandForwarderMap.remove(l);
    }

    void addStatusListener(StatusMessageListener l, BusMessageFilter filter) {
        ForwarderToStatusListeners forwarder = new ForwarderToStatusListeners(l, filter);
        this.statusForwarderMap.put(l, forwarder);
    }

    void removeStatusListener(StatusMessageListener l) {
        this.statusForwarderMap.remove(l);
    }

    void addLogListener(LogMessageListener l, BusMessageFilter filter) {
        ForwarderToLogListeners forwarder = new ForwarderToLogListeners(l, filter);
        this.logForwarderMap.put(l, forwarder);
    }

    void removeLogListener(LogMessageListener l) {
        this.logForwarderMap.remove(l);
    }

    void close() {
        this.busMessagingLayer.disconnect(this.messagingAccessLayer);
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.agentPresenceManager;
    }

    private class ForwarderToCommandExecutor
    implements BusMessageForwarder<CommandRequest> {
        private CommandExecutor commandExecutor = null;

        private ForwarderToCommandExecutor() {
        }

        void removeCommandExecutor() {
            this.commandExecutor = null;
        }

        void setCommandExecutor(CommandExecutor commandExecutor) {
            if (this.commandExecutor != null) {
                throw new RuntimeException("A CommandExecutor is already registered for this Agent. There can be only one!");
            }
            this.commandExecutor = commandExecutor;
        }

        @Override
        public void update(CommandRequest message) {
            String destination = message.getDestination();
            if (destination.contains("/")) {
                destination = destination.substring(0, destination.indexOf("/"));
            }
            if (!destination.equals(BusApplicationLayer.this.getAgentInfo().getName())) {
                return;
            }
            if (this.commandExecutor == null) {
                throw new RuntimeException("A CommandExecutor has not been registered for this Agent.");
            }
            try {
                this.commandExecutor.executeCommandRequest(message);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                log.error((Object)("on command :" + throwable), new String[0]);
            }
        }
    }

    private class ForwarderToCommandListeners
    implements BusMessageForwarder<CommandMessage> {
        private final CommandMessageListener listener;
        private final BusMessageFilter filter;

        ForwarderToCommandListeners(CommandMessageListener listener, BusMessageFilter filter) {
            this.listener = listener;
            this.filter = filter;
        }

        @Override
        public void update(CommandMessage message) {
            if (this.filter == null || this.filter.accept((BusMessage)message)) {
                this.listener.onCommandMessage(message);
            }
        }
    }

    private class ForwarderToCommandOriginator
    implements BusMessageForwarder<CommandReply> {
        private final HashMap<String, CommandOriginator> currentOriginators = new HashMap();

        ForwarderToCommandOriginator() {
        }

        void addCommandOriginator(String originatorId, CommandOriginator originator) {
            this.currentOriginators.put(originatorId, originator);
        }

        @Override
        public void update(CommandReply message) {
            String destination = message.getDestination();
            if (!destination.equals(BusApplicationLayer.this.getAgentInfo().getName())) {
                return;
            }
            String originatorId = message.getCommandOriginatorId();
            CommandOriginator commandOriginator = this.currentOriginators.get(originatorId);
            if (commandOriginator == null) {
                throw new RuntimeException("Could not find the origin of the CommandRequest " + message.getCommand());
            }
            if (message instanceof CommandAck) {
                commandOriginator.processAck((CommandAck)message);
            } else {
                if (message instanceof CommandNack) {
                    commandOriginator.processNack((CommandNack)message);
                } else if (message instanceof CommandResult) {
                    commandOriginator.processResult((CommandResult)message);
                } else if (message instanceof CommandError) {
                    commandOriginator.processError((CommandError)message);
                }
                this.currentOriginators.remove(originatorId);
            }
        }
    }

    private class ForwarderToLogListeners
    implements BusMessageForwarder<LogMessage> {
        private final LogMessageListener listener;
        private final BusMessageFilter filter;

        ForwarderToLogListeners(LogMessageListener listener, BusMessageFilter filter) {
            this.listener = listener;
            this.filter = filter;
        }

        @Override
        public void update(LogMessage message) {
            if (this.filter == null || this.filter.accept((BusMessage)message)) {
                this.listener.onLogMessage(message);
            }
        }
    }

    private class ForwarderToStatusListeners
    implements BusMessageForwarder<StatusMessage> {
        private final StatusMessageListener listener;
        private final boolean isEncodedListener;
        private final boolean isKeyValueListener;
        private final boolean isDataListener;
        private final boolean isCrystallizedListener;
        private final BusMessageFilter filter;

        ForwarderToStatusListeners(StatusMessageListener listener, BusMessageFilter filter) {
            this.listener = listener;
            this.filter = filter;
            this.isEncodedListener = listener instanceof EncodedStatusListens;
            this.isKeyValueListener = listener instanceof KeyValueStatusListener;
            this.isDataListener = listener instanceof DataStatusListener;
            this.isCrystallizedListener = listener instanceof SerializedDataStatusListener;
        }

        @Override
        public void update(StatusMessage message) {
            if (this.filter == null || this.filter.accept((BusMessage)message)) {
                if (this.isEncodedListener) {
                    if (message instanceof EncodedDataStatus) {
                        EncodedDataStatus status = (EncodedDataStatus)message;
                        String source = status.getOriginAgentInfo().getName();
                        for (EncodedDataStatus dataStatus : status) {
                            long timeStamp = dataStatus.getDataTimestamp();
                            KVList list = dataStatus.getContent();
                            for (KeyData keyData : list) {
                                Optional crysta;
                                Optional optObj;
                                String key = keyData.getKey();
                                if (this.isDataListener && (optObj = keyData.getValue()).isPresent()) {
                                    ((DataStatusListener)this.listener).onDataArrival(source, timeStamp, key, optObj.get());
                                }
                                if (this.isKeyValueListener) {
                                    int id = keyData.hashCode();
                                    List detailsList = keyData.getContentAsList();
                                    for (KeyData detaileddata : detailsList) {
                                        String complexKey = detaileddata.getKey();
                                        Optional optional = detaileddata.getValue();
                                        if (!optional.isPresent()) continue;
                                        ((KeyValueStatusListener)this.listener).onKeyValueStatusDecomposition(source, timeStamp, complexKey, optional.get(), id);
                                    }
                                }
                                if (!this.isCrystallizedListener || !(crysta = keyData.getCrystallizedData()).isPresent()) continue;
                                ((SerializedDataStatusListener)this.listener).onSerializedDataArrival(source, timeStamp, key, (byte[])crysta.get());
                            }
                        }
                    }
                } else {
                    this.listener.onStatusMessage(message);
                }
            }
        }
    }
}

