/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.AgentPresenceListener;
import org.lsst.ccs.bus.AgentPresenceManager;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.HeartBeatStatus;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusForEnd;

class DefaultAgentPresenceManager
extends AgentPresenceManager {
    private final Map<Agent, TimeoutTask> mapAgents = new HashMap<Agent, TimeoutTask>();
    private static final int SUSPICION_LENGTH = 3;
    private final Timer timer = new Timer(true);

    public DefaultAgentPresenceManager(String name) {
        super(name);
    }

    @Override
    public void onStatus(BusMessage s) {
        if (s instanceof Status) {
            Agent a = ((Status)s).getAgent();
            if (this.distInfoMap.get(a.getName()) == null && s instanceof HeartBeatStatus) {
                this.distInfoMap.put(a.getName(), ((HeartBeatStatus)s).getDistributionInfo());
            }
            if (s instanceof StatusForEnd) {
                log.debug((Object)"remove agent on status end", new String[0]);
                this.removeAgent(a);
            } else if (a != null) {
                int broadCastPeriod = s instanceof HeartBeatStatus ? ((HeartBeatStatus)s).getStatusBroadcastPeriod() : -1;
                this.updateAgent(a, broadCastPeriod);
            }
        }
    }

    private synchronized void updateAgent(Agent a, int tempBroadcastPeriod) {
        int statusBroadcastPeriod = -1;
        TimeoutTask task = this.mapAgents.get(a);
        if (task != null) {
            task.cancel();
            statusBroadcastPeriod = tempBroadcastPeriod == -1 ? task.getBroadcastPeriod() : tempBroadcastPeriod;
            task = new TimeoutTask(a, statusBroadcastPeriod);
            this.addAgent(a, task, false);
        } else {
            statusBroadcastPeriod = tempBroadcastPeriod == -1 ? 10 : tempBroadcastPeriod;
            task = new TimeoutTask(a, statusBroadcastPeriod);
            this.addAgent(a, task, true);
        }
        log.debug((Object)("resetting timer for agent " + a.getName() + " to " + statusBroadcastPeriod), new String[0]);
        this.timer.schedule((TimerTask)task, 3000 * statusBroadcastPeriod);
    }

    private synchronized void removeAgent(Agent agent) {
        log.debug((Object)("removing agent " + agent.getName()), new String[0]);
        TimeoutTask t = this.mapAgents.remove(agent);
        this.distInfoMap.remove(agent.getName());
        if (t != null) {
            t.cancel();
            this.disconnecting(agent);
        } else {
            log.debug((Object)"removing agent with null timer", new String[0]);
        }
    }

    private synchronized void addAgent(Agent agent, TimeoutTask task, boolean isNewAgent) {
        this.mapAgents.put(agent, task);
        if (isNewAgent) {
            this.connecting(agent);
        }
    }

    @Override
    public List<Agent> listAgent(int timeout) {
        return new ArrayList<Agent>(this.mapAgents.keySet());
    }

    @Override
    public List<Agent> listAgents(int timeout) {
        return this.listAgent(timeout);
    }

    @Override
    public void connecting(Agent agent) {
        for (AgentPresenceListener l : this.listAPL) {
            l.connecting(agent);
        }
    }

    @Override
    public void disconnecting(Agent agent) {
        for (AgentPresenceListener l : this.listAPL) {
            l.disconnecting(agent);
        }
    }

    @Override
    public void addAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.add(l);
    }

    @Override
    public void removeAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.remove(l);
    }

    class TimeoutTask
    extends TimerTask {
        private final Agent agent;
        private final int broadcastPeriod;

        TimeoutTask(Agent agent, int broadcastPeriod) {
            this.agent = agent;
            this.broadcastPeriod = broadcastPeriod;
        }

        int getBroadcastPeriod() {
            return this.broadcastPeriod;
        }

        @Override
        public void run() {
            DefaultAgentPresenceManager.this.removeAgent(this.agent);
        }
    }
}

