package org.lsst.ccs.bus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author emarin
 */
class AgentPresenceManagerBML extends AgentPresenceManager implements BusMembershipListener {

    // Map representing the agents connected on the status bus
    Map<String, Agent.AgentType> mapAgents = new HashMap<String, Agent.AgentType>();

    public AgentPresenceManagerBML(String name) {
        super(name);
    }

    /**
     * Lists agents that are connected on the Status Bus
     *
     * @param timeout
     * @return
     */
    @Override
    public List<Agent> listAgent(int timeout) {
        List<Agent> list = new ArrayList<Agent>();
        Set<Map.Entry<String, Agent.AgentType>> set = mapAgents.entrySet();
        for (Map.Entry<String, Agent.AgentType> e : set) {
            list.add(new Agent(e.getKey(), e.getValue()));
        }
        return list;
    }

    @Override
    public List<Agent> listAgents(int timeout) {
        return listAgent(timeout);
    }

    /**
     * Status listening only for connection information
     *
     * @param s
     */
    @Override
    public void onStatus(BusMessage s) {
        if (s instanceof Status && !(s instanceof StatusForEnd)) {
            Agent a = ((Status) s).getAgent();
            if (a != null) {
                if (distInfoMap.get(a.getName()) == null && s instanceof HeartBeatStatus) {
                    distInfoMap.put(a.getName(), ((HeartBeatStatus) s).getDistributionInfo());
                }
            }
            addAgent(a);
        }
    }

    public synchronized void addAgent(Agent a) {
        if (a != null && mapAgents.get(a.getName()) == null) {
            mapAgents.put(a.getName(), a.getType());
            connecting(a);
        }
    }

    public synchronized void removeAgent(String agentName) {
        log.debug("removing agent " + agentName);
        Agent.AgentType agentType = mapAgents.remove(agentName);
        distInfoMap.remove(agentName);
        if (agentType != null) {
            disconnecting(new Agent(agentName, agentType));
        }
    }

    @Override
    public void connecting(String agentName, String otherInfos) {
        // Do nothing : handled internally with the onStatus method
    }

    @Override
    public void disconnecting(String agentName, String otherInfos) {
        removeAgent(agentName);
    }

    @Override
    public void anormalEvent(Exception exc) {
        // We do nothing, an other BusMembershipListener is in charge 
    }

}
