package org.lsst.ccs.bus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author emarin
 */
public abstract class AgentPresenceManager implements StatusListener {
    
    final CopyOnWriteArrayList<AgentPresenceListener> listAPL = new CopyOnWriteArrayList<>();
    final String name;
    final Map<String,DistributionInfo> distInfoMap = new HashMap<>();
   
    protected static Logger log = Logger.getLogger("org.lsst.ccs.bus");
    
    
    
    public AgentPresenceManager(String name){
        this.name = name;
    }
    
    
    public abstract List<Agent> listAgent(int timeout);
    
    public abstract List<Agent> listAgents(int timeout);
    
    public void connecting(Agent agent){        
        for (AgentPresenceListener l : listAPL){
            l.connecting(agent);
        }
    }
    
    public void disconnecting(Agent agent){
        for (AgentPresenceListener l : listAPL){
            l.disconnecting(agent);
        }
    }
    
    public void addAgentPresenceListener(AgentPresenceListener l){
        listAPL.add(l);
    }

    public void removeAgentPresenceListener(AgentPresenceListener l){
        listAPL.remove(l);
    }
    
    public DistributionInfo getAgentDistributionInfo(String agentName) {
        return distInfoMap.get(agentName);
    }

    /**
     * Get the CCSVersions for the current CCS Environment.
     * 
     */
    public CCSVersions getCCSVersions() {
        CCSVersions ccsVersions = new CCSVersions();
        List<Agent> agents = listAgents(1);
        for ( Agent a : agents ) {
            DistributionInfo d = getAgentDistributionInfo(a.getName());
            if (  d != null ) {
                ccsVersions.add(a, d);
            }
        }
        return ccsVersions;
    }
    
}
