/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.AgentPresenceManager;
import org.lsst.ccs.bus.AgentPresenceManagerBML;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusApplicationLayer;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.DefaultAgentPresenceManager;
import org.lsst.ccs.bus.DestinationsException;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.LogListener;
import org.lsst.ccs.bus.ProvidesDisconnectionInformation;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.bus.TransportException;
import org.lsst.ccs.bus.TransportManager;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Names;
import org.lsst.ccs.utilities.tracers.Tracer;

public class MessagingFactory {
    protected static volatile MessagingFactory instance;
    private final Map<String, InnerFactory> map = new HashMap<String, InnerFactory>();
    private final Logger curLogger = Logger.getLogger((String)"org.lsst.ccs.bus");
    private AgentPresenceManager agentPresenceManager;
    private String subsystemName;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !MessagingFactory.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev$", MessagingFactory.class, (String)"org-lsst-ccs-messaging-layer")) {
            throw new AssertionError();
        }
    }

    public static synchronized MessagingFactory getInstance() {
        if (instance == null) {
            MessagingFactory.instanciate();
        }
        return instance;
    }

    protected static void instanciate() {
        try {
            instance = new MessagingFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MessagingFactory forSubsystem(String name) {
        BusMessagingLayer busMessagingLayer;
        String protocolProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport", "jgroups:udp_ccs:");
        String transportPropsProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport.properties", "");
        try {
            busMessagingLayer = TransportManager.getConnection(protocolProperty, transportPropsProperty);
        }
        catch (TransportException exc) {
            throw new RuntimeException(exc);
        }
        boolean toshareJVM = "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.sharedJVM", "false").toUpperCase());
        InnerFactory fact = this.map.get(name);
        if (fact == null) {
            fact = new InnerFactory(name, busMessagingLayer);
            this.map.put(name, fact);
        } else {
            BusMessagingLayer layer = fact.layer.getBusMessagingLayer();
            if (!layer.getClass().isAssignableFrom(busMessagingLayer.getClass())) {
                this.curLogger.warn((Object)("LAYER CHANGE! OLD LAYER :" + layer + " NEW LAYER : " + busMessagingLayer), new String[0]);
                fact = new InnerFactory(name, busMessagingLayer);
                this.map.put(name, fact);
            }
        }
        fact.sharedJVM = toshareJVM;
        return fact;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    public boolean isReplyRequested() {
        return false;
    }

    public void shutdownBusAccess() {
    }

    public List<String> connectedToCommand() {
        return Collections.EMPTY_LIST;
    }

    public void addCommandListener(CommandListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public synchronized void removeCommandListener(CommandListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void addStatusListener(StatusListens l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public synchronized void removeStatusListener(StatusListens l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void addLogListener(LogListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public synchronized void removeLogListener(LogListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void addCommandListener(CommandListener l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void addStatusListener(StatusListens l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void addLogListener(LogListener l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void sendCommand(Command cmd) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void sendStatus(Status status) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void sendLogEvent(LogEvent evt) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public String getToken() {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void reply(CommandAckOrReply cmd) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void noAutoReply() {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void addMembershipListener(BusMembershipListener l, Bus bus) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public void removeMembershipListener(BusMembershipListener l, Bus bus) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    public AgentPresenceManager getAgentPresenceManager() {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    static class BooleanWrapper {
        AtomicBoolean atomicBoolean = new AtomicBoolean();

        public BooleanWrapper() {
            System.out.println(" build invoke " + this);
        }

        public boolean get() {
            return this.atomicBoolean.get();
        }

        public void set(boolean newValue) {
            this.atomicBoolean.set(newValue);
        }

        public String toString() {
            return String.valueOf(super.toString()) + " " + this.atomicBoolean;
        }
    }

    private class InnerFactory
    extends MessagingFactory {
        final BusMessagingLayer transportLayer;
        final BusApplicationLayer layer;
        private final boolean[] registered = new boolean[Bus.values().length];
        private boolean autoReply = true;
        volatile boolean sharedJVM = false;
        private final String messagingAccessName;

        InnerFactory(String subSystem, BusMessagingLayer transport) {
            this.transportLayer = transport;
            this.layer = new BusApplicationLayer(subSystem, transport);
            this.messagingAccessName = subSystem;
        }

        @Override
        public synchronized void addCommandListener(CommandListener l) {
            if (this.sharedJVM || !this.registered[Bus.COMMAND.ordinal()]) {
                try {
                    this.layer.registerToCommand();
                }
                catch (RuntimeException exc) {
                    throw exc;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.registered[Bus.COMMAND.ordinal()] = true;
            }
            this.layer.addCommandListener(l);
        }

        @Override
        public synchronized void removeCommandListener(CommandListener l) {
            this.layer.removeCommandListener(l);
        }

        @Override
        public synchronized void addStatusListener(StatusListens l) {
            if (!this.registered[Bus.STATUS.ordinal()]) {
                try {
                    this.layer.registerToStatus();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.registered[Bus.STATUS.ordinal()] = true;
            }
            this.layer.addStatusListener(l);
        }

        @Override
        public synchronized void removeStatusListener(StatusListens l) {
            this.layer.removeStatusListener(l);
        }

        @Override
        public synchronized void addLogListener(LogListener l) {
            if (!this.registered[Bus.LOG.ordinal()]) {
                try {
                    this.layer.registerToLog();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.registered[Bus.LOG.ordinal()] = true;
            }
            this.layer.addLogListener(l);
        }

        @Override
        public synchronized void removeLogListener(LogListener l) {
            this.layer.removeLogListener(l);
        }

        @Override
        public void addCommandListener(CommandListener l, String selector) {
            this.addCommandListener(l);
        }

        @Override
        public void addStatusListener(StatusListens l, String selector) {
            this.addStatusListener(l);
        }

        @Override
        public void addLogListener(LogListener l, String selector) {
            this.addLogListener(l);
        }

        @Override
        public synchronized void sendCommand(Command cmd) {
            try {
                if (!this.registered[Bus.COMMAND.ordinal()]) {
                    this.layer.registerToCommand();
                    this.registered[Bus.COMMAND.ordinal()] = true;
                }
                this.layer.sendCommand(cmd);
            }
            catch (IOException e) {
                if (e instanceof DestinationsException) {
                    MessagingFactory.this.curLogger.warn((Object)"destination problem", (Throwable)e, new String[0]);
                    throw new RuntimeException(e);
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public synchronized void sendStatus(Status status) {
            try {
                if (!this.registered[Bus.STATUS.ordinal()]) {
                    this.layer.registerToStatus();
                    this.registered[Bus.STATUS.ordinal()] = true;
                }
                this.layer.sendStatus(status);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public synchronized void sendLogEvent(LogEvent evt) {
            try {
                if (!this.registered[Bus.LOG.ordinal()]) {
                    this.layer.registerToLog();
                    this.registered[Bus.LOG.ordinal()] = true;
                }
                this.layer.sendLogEvent(evt);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getToken() {
            return this.layer.getToken();
        }

        @Override
        public void reply(CommandAckOrReply cmd) {
            try {
                this.layer.reply(cmd);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void noAutoReply() {
            this.autoReply = false;
        }

        @Override
        public boolean isReplyRequested() {
            return this.autoReply;
        }

        @Override
        public void shutdownBusAccess() {
            this.layer.close();
            int ix = 0;
            while (ix < this.registered.length) {
                this.registered[ix] = false;
                ++ix;
            }
            MessagingFactory.this.map.remove(this.messagingAccessName);
            if (MessagingFactory.this.map.size() == 1 && MessagingFactory.this.agentPresenceManager != null) {
                MessagingFactory.getInstance().forSubsystem(((MessagingFactory)MessagingFactory.this).agentPresenceManager.name).shutdownBusAccess();
                MessagingFactory.this.agentPresenceManager = null;
            }
        }

        @Override
        public List<String> connectedToCommand() {
            return this.layer.connectedToCommand();
        }

        @Override
        public synchronized void addMembershipListener(BusMembershipListener l, Bus bus) {
            this.layer.addMembershipListener(l, bus);
        }

        @Override
        public synchronized void removeMembershipListener(BusMembershipListener l, Bus bus) {
            this.layer.removeMembershipListener(l, bus);
        }

        @Override
        public synchronized AgentPresenceManager getAgentPresenceManager() {
            if (MessagingFactory.this.agentPresenceManager == null) {
                String apmName = Names.almostUniqueAgentName((String)"apm");
                if (this.transportLayer instanceof ProvidesDisconnectionInformation) {
                    MessagingFactory.this.agentPresenceManager = new AgentPresenceManagerBML(apmName);
                    this.layer.addMembershipListener((BusMembershipListener)((Object)MessagingFactory.this.agentPresenceManager), Bus.STATUS);
                } else {
                    MessagingFactory.this.agentPresenceManager = new DefaultAgentPresenceManager(apmName);
                }
                MessagingFactory.getInstance().forSubsystem(apmName).addStatusListener(MessagingFactory.this.agentPresenceManager);
            }
            return MessagingFactory.this.agentPresenceManager;
        }
    }
}

