/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.AgentPresenceManager;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.HeartBeatStatus;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusForEnd;

class AgentPresenceManagerBML
extends AgentPresenceManager
implements BusMembershipListener {
    Map<String, Agent.AgentType> mapAgents = new HashMap<String, Agent.AgentType>();

    public AgentPresenceManagerBML(String name) {
        super(name);
    }

    @Override
    public List<Agent> listAgent(int timeout) {
        ArrayList<Agent> list = new ArrayList<Agent>();
        Set<Map.Entry<String, Agent.AgentType>> set = this.mapAgents.entrySet();
        for (Map.Entry<String, Agent.AgentType> e : set) {
            list.add(new Agent(e.getKey(), e.getValue()));
        }
        return list;
    }

    @Override
    public List<Agent> listAgents(int timeout) {
        return this.listAgent(timeout);
    }

    @Override
    public void onStatus(BusMessage s) {
        if (s instanceof Status && !(s instanceof StatusForEnd)) {
            Agent a = ((Status)s).getAgent();
            if (a != null && this.distInfoMap.get(a.getName()) == null && s instanceof HeartBeatStatus) {
                this.distInfoMap.put(a.getName(), ((HeartBeatStatus)s).getDistributionInfo());
            }
            this.addAgent(a);
        }
    }

    public synchronized void addAgent(Agent a) {
        if (a != null && this.mapAgents.get(a.getName()) == null) {
            this.mapAgents.put(a.getName(), a.getType());
            this.connecting(a);
        }
    }

    public synchronized void removeAgent(String agentName) {
        log.debug((Object)("removing agent " + agentName), new String[0]);
        Agent.AgentType agentType = this.mapAgents.remove(agentName);
        this.distInfoMap.remove(agentName);
        if (agentType != null) {
            this.disconnecting(new Agent(agentName, agentType));
        }
    }

    @Override
    public void connecting(String agentName, String otherInfos) {
    }

    @Override
    public void disconnecting(String agentName, String otherInfos) {
        this.removeAgent(agentName);
    }

    @Override
    public void anormalEvent(Exception exc) {
    }
}

