/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.AgentPresenceListener;
import org.lsst.ccs.bus.CCSVersions;
import org.lsst.ccs.bus.DistributionInfo;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class AgentPresenceManager
implements StatusListener {
    final CopyOnWriteArrayList<AgentPresenceListener> listAPL = new CopyOnWriteArrayList();
    final String name;
    final Map<String, DistributionInfo> distInfoMap = new HashMap<String, DistributionInfo>();
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.bus");

    public AgentPresenceManager(String name) {
        this.name = name;
    }

    public abstract List<Agent> listAgent(int var1);

    public abstract List<Agent> listAgents(int var1);

    public void connecting(Agent agent) {
        for (AgentPresenceListener l : this.listAPL) {
            l.connecting(agent);
        }
    }

    public void disconnecting(Agent agent) {
        for (AgentPresenceListener l : this.listAPL) {
            l.disconnecting(agent);
        }
    }

    public void addAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.add(l);
    }

    public void removeAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.remove(l);
    }

    public DistributionInfo getAgentDistributionInfo(String agentName) {
        return this.distInfoMap.get(agentName);
    }

    public CCSVersions getCCSVersions() {
        CCSVersions ccsVersions = new CCSVersions();
        List<Agent> agents = this.listAgents(1);
        for (Agent a : agents) {
            DistributionInfo d = this.getAgentDistributionInfo(a.getName());
            if (d == null) continue;
            ccsVersions.add(a, d);
        }
        return ccsVersions;
    }
}

