package org.lsst.ccs.bus;

import java.util.List;

/**
 *
 * @author emarin
 */
public interface ProvidesDisconnectionInformation {
        
    /**
     * optional operation.
     * registers a listener for knowing about the agents that connect/disconnect on a bus.
     * This method is more useful if called before any agent registration (for instance
     * duplicate agent names will be reported to these listeners)
     *
     * @param buses if empty  register to all buses
     * @param listener can be null if we want to deregister a previous listener
     * @throws UnsupportedOperationException if not supported
     */
    public void setMembershipListener( BusMembershipListener listener, Bus... buses);


    /**
     * Tries to return the name of a list of  agents connected to a bus.
     * @param bus
     * @return a (possibly empty) list of agent's names connected to a bus
     *  if the current calling code is not connected to this bus the list will be empty
     */
    public List<String> getConnectedNames(Bus bus) ;

    public BusMembershipListener getBusMembershipListener(Bus bus);
    
}
