/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.KeyValueStatusListener;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusAggregator
implements KeyValueStatusListener {
    Map<String, StatusAggregateConfig> config = new ConcurrentHashMap<String, StatusAggregateConfig>();
    Map<String, StatusAggregateConfig> patternConfig = new ConcurrentHashMap<String, StatusAggregateConfig>();
    Map<String, ConcurrentLinkedQueue<TimedValue>> history = new ConcurrentHashMap<String, ConcurrentLinkedQueue<TimedValue>>();
    Map<String, TimedValue> last = new ConcurrentHashMap<String, TimedValue>();
    Map<String, TimedValueStats> stats = new ConcurrentHashMap<String, TimedValueStats>();
    List<Pattern> patterns = new ArrayList<Pattern>();
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.bus");

    public void setAggregate(String key, int historyDuration, int aggregateWindow) {
        this.config.put(key, new StatusAggregateConfig(key, historyDuration, aggregateWindow));
        if (historyDuration > 0 || aggregateWindow > 0) {
            this.history.put(key, new ConcurrentLinkedQueue());
        }
        if (aggregateWindow > 0) {
            this.stats.put(key, new TimedValueStats());
        }
    }

    public void setAggregatePattern(String pattern, int historyDuration, int aggregateWindow) {
        this.setAggregatePattern(Pattern.compile(pattern), historyDuration, aggregateWindow);
    }

    public void setAggregatePattern(Pattern pattern, int historyDuration, int aggregateWindow) {
        StatusAggregateConfig c = new StatusAggregateConfig(pattern, historyDuration, aggregateWindow);
        this.patternConfig.put(c.name, c);
    }

    public void clearAggregate(String key) {
        this.config.remove(key);
        this.history.remove(key);
        this.stats.remove(key);
        this.last.remove(key);
    }

    protected StatusAggregateConfig getConfig(String key) {
        StatusAggregateConfig c = this.config.get(key);
        if (c != null) {
            return c;
        }
        for (Map.Entry<String, StatusAggregateConfig> e : this.patternConfig.entrySet()) {
            c = e.getValue();
            if (!c.pattern.matcher(key).matches()) continue;
            c = new StatusAggregateConfig(key, c.historyDuration, c.aggregateWindow);
            this.config.put(key, c);
            if (c.historyDuration > 0 || c.aggregateWindow > 0) {
                this.history.put(key, new ConcurrentLinkedQueue());
            }
            if (c.aggregateWindow > 0) {
                this.stats.put(key, new TimedValueStats());
            }
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKeyValueStatusDecomposition(String source, long timeStamp, String key, Object value, int commonID) {
        int kept;
        this.log.debug((Object)("SA from " + source + " : " + key + "  > " + value), new String[0]);
        String k = String.valueOf(source) + '/' + key;
        StatusAggregateConfig c = this.getConfig(k);
        if (c == null) {
            return;
        }
        this.log.debug((Object)("SA get " + k + " " + value), new String[0]);
        this.last.put(k, new TimedValue(k, timeStamp, value));
        int n = kept = c.historyDuration > c.aggregateWindow ? c.historyDuration : c.aggregateWindow;
        if (kept < 0) {
            return;
        }
        this.log.debug((Object)("keeping " + kept + " for " + k), new String[0]);
        long aggregateBound = c.aggregateWindow < 0 ? Long.MAX_VALUE : timeStamp - (long)c.aggregateWindow;
        long stopBound = timeStamp - (long)kept;
        ConcurrentLinkedQueue<TimedValue> q = this.history.get(k);
        if (q == null) {
            q = new ConcurrentLinkedQueue();
            this.history.put(k, q);
        }
        ConcurrentLinkedQueue<TimedValue> concurrentLinkedQueue = q;
        synchronized (concurrentLinkedQueue) {
            TimedValue v;
            q.add(new TimedValue(k, timeStamp, value));
            if (c.aggregateWindow > 0) {
                TimedValueStats st = this.stats.get(k);
                if (st == null) {
                    st = new TimedValueStats();
                    this.stats.put(k, st);
                }
                if (value instanceof Number) {
                    st.add(((Number)value).doubleValue());
                }
                if (aggregateBound > st.firstSample) {
                    long firstRemaining = Long.MAX_VALUE;
                    for (TimedValue v2 : q) {
                        if (v2.tStamp < aggregateBound && v2.tStamp >= st.firstSample && v2.value instanceof Number) {
                            st.remove(((Number)v2.value).doubleValue(), q, aggregateBound);
                            continue;
                        }
                        if (v2.tStamp >= firstRemaining || v2.tStamp < aggregateBound) continue;
                        firstRemaining = v2.tStamp;
                    }
                    st.firstSample = firstRemaining;
                }
            }
            while ((v = q.peek()) != null && v.tStamp < stopBound) {
                q.poll();
            }
        }
    }

    public Object getLast(String key) {
        TimedValue v = this.last.get(key);
        return v == null ? null : v.value;
    }

    public TimedValue getLastTV(String key) {
        return this.last.get(key);
    }

    public double getAverage(String key) {
        TimedValueStats st = this.stats.get(key);
        if (st == null) {
            throw new NoSuchElementException();
        }
        if (st.n == 0) {
            return 0.0;
        }
        return st.average();
    }

    public double getStdDev(String key) {
        TimedValueStats st = this.stats.get(key);
        if (st == null) {
            throw new NoSuchElementException();
        }
        if (st.n == 0) {
            return 0.0;
        }
        return st.stddev();
    }

    public double getMin(String key) {
        TimedValueStats st = this.stats.get(key);
        if (st == null) {
            throw new NoSuchElementException();
        }
        if (st.n == 0) {
            return 0.0;
        }
        return st.min;
    }

    public double getMax(String key) {
        TimedValueStats st = this.stats.get(key);
        if (st == null) {
            throw new NoSuchElementException();
        }
        if (st.n == 0) {
            return 0.0;
        }
        return st.max;
    }

    public List<TimedValue> getHistory(String key) {
        ConcurrentLinkedQueue<TimedValue> hh = this.history.get(key);
        if (hh == null) {
            return null;
        }
        ArrayList<TimedValue> l = new ArrayList<TimedValue>();
        StatusAggregateConfig cf = this.config.get(key);
        long lastSample = this.last.get(key).tStamp;
        long firstSample = lastSample - (long)cf.historyDuration;
        for (TimedValue tv : hh) {
            if (tv.tStamp < firstSample) continue;
            l.add(tv);
        }
        return l.size() == 0 ? null : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getStatistics(String key) {
        Statistics s;
        ConcurrentLinkedQueue<TimedValue> q;
        ConcurrentLinkedQueue<TimedValue> concurrentLinkedQueue = q = this.history.get(key);
        synchronized (concurrentLinkedQueue) {
            s = new Statistics(this.getMin(key), this.getMax(key), this.getAverage(key), this.getStdDev(key));
        }
        return s;
    }

    public Map<String, Object> getAllLast() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String k : this.last.keySet()) {
            m.put(k, this.getLast(k));
        }
        return m;
    }

    public Map<String, TimedValue> getAllLastTV() {
        HashMap<String, TimedValue> m = new HashMap<String, TimedValue>();
        for (String k : this.last.keySet()) {
            m.put(k, this.getLastTV(k));
        }
        return m;
    }

    public Map<String, Statistics> getAllStatistics() {
        HashMap<String, Statistics> m = new HashMap<String, Statistics>();
        for (String k : this.stats.keySet()) {
            m.put(k, this.getStatistics(k));
        }
        return m;
    }

    public static class Statistics {
        private double min;
        private double max;
        private double average;
        private double stddev;

        public Statistics(double min, double max, double average, double stddev) {
            this.min = min;
            this.max = max;
            this.average = average;
            this.stddev = stddev;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getAverage() {
            return this.average;
        }

        public double getStddev() {
            return this.stddev;
        }
    }

    private static class StatusAggregateConfig {
        public String name;
        public Pattern pattern;
        public int historyDuration;
        public int aggregateWindow;

        public StatusAggregateConfig(String name, int historyDuration, int aggregateWindow) {
            this.name = name;
            this.historyDuration = historyDuration;
            this.aggregateWindow = aggregateWindow;
        }

        public StatusAggregateConfig(Pattern pattern, int historyDuration, int aggregateWindow) {
            this.pattern = pattern;
            this.name = pattern.toString();
            this.historyDuration = historyDuration;
            this.aggregateWindow = aggregateWindow;
        }
    }

    public static class TimedValue {
        private String name;
        private long tStamp;
        private Object value;

        public TimedValue(String name, long tStamp, Object value) {
            this.name = name;
            this.tStamp = tStamp;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public long gettStamp() {
            return this.tStamp;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private static class TimedValueStats {
        public String name;
        public int n = 0;
        public double sum = 0.0;
        public double sum2 = 0.0;
        public double min = Double.MAX_VALUE;
        public double max = Double.MIN_NORMAL;
        public long firstSample;

        private TimedValueStats() {
        }

        public double average() {
            return this.n > 0 ? this.sum / (double)this.n : 0.0;
        }

        public double stddev() {
            if (this.n == 0) {
                return 0.0;
            }
            return Math.sqrt(this.sum2 / (double)this.n - this.sum * this.sum / (double)(this.n * this.n));
        }

        public void add(double value) {
            this.sum += value;
            this.sum2 += value * value;
            ++this.n;
            this.updateMinMaxIn(value);
        }

        public void remove(double value, ConcurrentLinkedQueue<TimedValue> h, long bound) {
            this.sum -= value;
            this.sum2 -= value * value;
            --this.n;
            this.updateMinMaxOut(value, h, bound);
        }

        private void updateMinMaxIn(double newValue) {
            if (newValue < this.min) {
                this.min = newValue;
            }
            if (newValue > this.max) {
                this.max = newValue;
            }
        }

        private void updateMinMaxOut(double removedValue, ConcurrentLinkedQueue<TimedValue> h, long bound) {
            if (removedValue <= this.min || removedValue >= this.max) {
                this.min = Double.MAX_VALUE;
                this.max = Double.MIN_NORMAL;
                for (TimedValue v : h) {
                    if (v.tStamp < bound || !(v.value instanceof Number)) continue;
                    double x = ((Number)v.value).doubleValue();
                    if (x > this.max) {
                        this.max = x;
                    }
                    if (!(x < this.min)) continue;
                    this.min = x;
                }
            }
        }
    }
}

