package org.lsst.ccs.bus;

import org.lsst.ccs.utilities.logging.Logger;

import java.util.logging.Level;

/**
 * @author bamade
 */
// Date: 31/07/13

public class DefaultLogMembershipListener implements BusMembershipListener{
    protected static Logger localLog = Logger.getLogger("org.lsst.ccs.bus.layer");
    protected static Logger generalLog = Logger.getLogger("org.lsst.ccs.bus.layer.general");
    public static long logDelay = 200;

    public static long getLogDelay() {
        return logDelay;
    }

    public static void setLogDelay(long logDelay) {
        DefaultLogMembershipListener.logDelay = logDelay;
    }

    @Override
    public void connecting(String agentName, String otherInfos) {
        localLog.info("connecting: " + agentName + "[" + otherInfos +"]");
    }

    @Override
    public void disconnecting(String agentName, String otherInfos) {
        localLog.info("disconnecting: " + agentName + "[" + otherInfos +"]");
    }

    @Override
    public void anormalEvent(final Exception exc) {
                generalLog.decoupledLog(logDelay, Level.WARNING, "communication layer log: ", exc);
    }
}
