package org.lsst.ccs.bus;

/**
 * records the events that warn about a bus membership: connection, disconnection or suspicion of loss of connection.
 * @implNote
 * initially there was only one MembershipListener per bus and per CommunicationLayer : see Multiplexor in BusApplicationLayer.
 *
 */
public interface BusMembershipListener {
    /**
     * a new agent is connected to the bus
     * @param agentName
     * @param otherInfos free form string to add comments to the event
     */
    public void connecting(String agentName,String otherInfos );

    /**
     * an agent explicitly disconnected
     * @param agentName
     * @param otherInfos
     */
    public void disconnecting(String agentName,String otherInfos );

    /**
     * notification of an incident (sending a message to a non-existing agent and so on)
     * @param exc
     */
    public void anormalEvent(Exception exc) ;
}
