package org.lsst.ccs.bus;

import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Tracer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BusMessagingFactory extends MessagingFactory{
    static {
        assert Tracer.version("$Rev$", BusMessagingFactory.class, "org-lsst-ccs-messaging-layer") ;
    }

    private BusMessagingLayer busMessagingLayer ;
    private final Map<String,InnerFactory> map = new HashMap<>() ;
    private final Logger curLogger = Logger.getLogger("org.lsst.ccs.bus") ;

    private class InnerFactory extends MessagingFactory {
        private final String subSystem ;
        private final BusApplicationLayer layer ;
        private final boolean[] registered = new boolean[Bus.values().length];
        private boolean autoReply = true ;

        InnerFactory(String subSystem, BusMessagingLayer transport) {
            this.subSystem = subSystem;
            this.layer = new BusApplicationLayer(subSystem, transport);
        }

        @Override
        public synchronized void addCommandListener(CommandListener l) {
            if(! registered[Bus.COMMAND.ordinal()]){
                try {
                    layer.registerToCommand();
                } catch (IOException e) {
                    //TODO: change that!
                    throw new RuntimeException(e) ;
                }
                registered[Bus.COMMAND.ordinal()] = true ;
            }
            layer.addCommandListener(l);
        }

        @Override
        public synchronized void removeCommandListener(CommandListener l) {
            layer.removeCommandListener(l);
        }

        @Override
        public  synchronized void addStatusListener(StatusListens l) {
            if(! registered[Bus.STATUS.ordinal()]){
                try {
                    layer.registerToStatus();
                } catch (IOException e) {
                    throw new RuntimeException(e) ;
                }
                registered[Bus.STATUS.ordinal()] = true ;
            }
            layer.addStatusListener(l);
        }
        @Override
        public synchronized void removeStatusListener(StatusListens l) {
            layer.removeStatusListener(l);
        }

        @Override
        public synchronized void addLogListener(LogListener l) {
            if(! registered[Bus.LOG.ordinal()]){
                try {
                    layer.registerToLog();
                } catch (IOException e) {
                    throw new RuntimeException(e) ;
                }
                registered[Bus.LOG.ordinal()] = true ;
            }
            layer.addLogListener(l);
        }
        @Override
        public synchronized void removeLogListener(LogListener l) {
            layer.removeLogListener(l);
        }

        @Override
        public void addCommandListener(CommandListener l, String selector) {
            addCommandListener(l);
        }

        @Override
        public void addStatusListener(StatusListens l, String selector) {
            addStatusListener(l);
        }

        @Override
        public void addLogListener(LogListener l, String selector) {
            addLogListener(l);
        }

        @Override
        public synchronized void sendCommand(Command cmd) {
            try {
                if(! registered[Bus.COMMAND.ordinal()]){
                    layer.registerToCommand();
                    registered[Bus.COMMAND.ordinal()] = true ;
                }
                //TODO: check if Command without Origin!
                layer.sendCommand(cmd);
            } catch (IOException e) {
                //TODO:change that!!!
              if(e instanceof DestinationsException) {
                  //System.out.println(" Log WARN: " + e);
                  curLogger.warn("destination problem", e) ;
                  // toDO : wit until lock arbitrator
                  // The exception is thrown again to address https://jira.slac.stanford.edu/browse/LSSTCCS-181
                  // In the future we might want to have smarter logic to address any
                  // LockArbitrator issues.
                  throw new RuntimeException(e);
              } else {
                throw new RuntimeException(e);
              }
            }
        }

        @Override
        public synchronized void sendStatus(Status status) {
            try {
                if(! registered[Bus.STATUS.ordinal()]){
                    layer.registerToStatus();
                    registered[Bus.STATUS.ordinal()] = true ;
                }
                layer.sendStatus(status);
            } catch (IOException e) {
                //TODO:change that!!!
                throw new RuntimeException(e);
            }
            //To change body of implemented methods use File | Settings | File Templates.
        }

        @Override
        public synchronized void sendLogEvent(LogEvent evt) {
            try {
                if(! registered[Bus.LOG.ordinal()]){
                    layer.registerToLog();
                    registered[Bus.LOG.ordinal()] = true ;
                }
                layer.sendLogEvent(evt);
            } catch (IOException e) {
                //TODO:change that!!!
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getToken() {
            return layer.getToken();
        }

        @Override
        public void reply(CommandAckOrReply cmd) {
            try {
                layer.reply(cmd);
            } catch (IOException e) {
                //TODO:change that!!!
                throw new RuntimeException(e);
            }
        }

        @Override
        public void noAutoReply() {
            autoReply = false ;
        }

        // TODO: change that .....
        @Override
        public boolean isReplyRequested(){
            return this.autoReply ;
        }

        @Override
        public void shutdownBusAccess() {
            layer.close() ;
            for(int ix = 0 ; ix < registered.length; ix++) {
                registered[ix] = false ;
            }

        }
        @Override
        public List<String> connectedToCommand() {
            return layer.connectedToCommand() ;
        }

        @Override
        public synchronized void addMembershipListener(BusMembershipListener l) {
           layer.addMembershipListener(l);
        }

        @Override
        public synchronized void removeMembershipListener(BusMembershipListener l) {
           layer.removeMembershipListener(l);
        }
    }
    
    ///////////////////////////////////////// CTOR
    
    public BusMessagingFactory() {
        String protocolProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport", "jgroups:udp_ccs:") ;
        String transportPropsProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport.properties", "");
        try {
        //busMessagingLayer = (BusMessagingLayer) Class.forName(clazzName).newInstance();
            busMessagingLayer = TransportManager.getConnection(protocolProperty,transportPropsProperty) ;
        } catch (TransportException exc) {
            //todo: change this exception
            throw new RuntimeException(exc) ;
        }
    }
    
    @Override
    public  synchronized MessagingFactory forSubsystem(String name) {
        InnerFactory fact = map.get(name) ;
        if(fact == null ) {
            fact = new InnerFactory(name, busMessagingLayer);
            map.put(name, fact) ;
        }
        return fact ;
    }
    ///////////////////////////////////////// METHODS
    
    @Override
    public void addCommandListener(CommandListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }
    @Override
    public synchronized void removeCommandListener(CommandListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void addStatusListener(StatusListens l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }
    @Override
    public synchronized void removeStatusListener(StatusListens l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void addLogListener(LogListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public synchronized void removeLogListener(LogListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void addCommandListener(CommandListener l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void addStatusListener(StatusListens l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void addLogListener(LogListener l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void sendCommand(Command cmd) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void sendStatus(Status status) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void sendLogEvent(LogEvent evt) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public String getToken() {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
        //return null;
    }

    @Override
    public void reply(CommandAckOrReply cmd) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void noAutoReply() {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }
        
    @Override
    public void addMembershipListener(BusMembershipListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void removeMembershipListener(BusMembershipListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }
}
