/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusApplicationLayer;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.DestinationsException;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.LogListener;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.bus.TransportException;
import org.lsst.ccs.bus.TransportManager;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Tracer;

public class BusMessagingFactory
extends MessagingFactory {
    private BusMessagingLayer busMessagingLayer;
    private final Map<String, InnerFactory> map = new HashMap<String, InnerFactory>();
    private final Logger curLogger = Logger.getLogger((String)"org.lsst.ccs.bus");
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !BusMessagingFactory.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev$", BusMessagingFactory.class, (String)"org-lsst-ccs-messaging-layer")) {
            throw new AssertionError();
        }
    }

    public BusMessagingFactory() {
        String protocolProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport", "jgroups:udp_ccs:");
        String transportPropsProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport.properties", "");
        try {
            this.busMessagingLayer = TransportManager.getConnection(protocolProperty, transportPropsProperty);
        }
        catch (TransportException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public synchronized MessagingFactory forSubsystem(String name) {
        InnerFactory fact = this.map.get(name);
        if (fact == null) {
            fact = new InnerFactory(name, this.busMessagingLayer);
            this.map.put(name, fact);
        }
        return fact;
    }

    @Override
    public void addCommandListener(CommandListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public synchronized void removeCommandListener(CommandListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void addStatusListener(StatusListens l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public synchronized void removeStatusListener(StatusListens l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void addLogListener(LogListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public synchronized void removeLogListener(LogListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void addCommandListener(CommandListener l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void addStatusListener(StatusListens l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void addLogListener(LogListener l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void sendCommand(Command cmd) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void sendStatus(Status status) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void sendLogEvent(LogEvent evt) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public String getToken() {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void reply(CommandAckOrReply cmd) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void noAutoReply() {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void addMembershipListener(BusMembershipListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void removeMembershipListener(BusMembershipListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    private class InnerFactory
    extends MessagingFactory {
        private final String subSystem;
        private final BusApplicationLayer layer;
        private final boolean[] registered = new boolean[Bus.values().length];
        private boolean autoReply = true;

        InnerFactory(String subSystem, BusMessagingLayer transport) {
            this.subSystem = subSystem;
            this.layer = new BusApplicationLayer(subSystem, transport);
        }

        @Override
        public synchronized void addCommandListener(CommandListener l) {
            if (!this.registered[Bus.COMMAND.ordinal()]) {
                try {
                    this.layer.registerToCommand();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.registered[Bus.COMMAND.ordinal()] = true;
            }
            this.layer.addCommandListener(l);
        }

        @Override
        public synchronized void removeCommandListener(CommandListener l) {
            this.layer.removeCommandListener(l);
        }

        @Override
        public synchronized void addStatusListener(StatusListens l) {
            if (!this.registered[Bus.STATUS.ordinal()]) {
                try {
                    this.layer.registerToStatus();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.registered[Bus.STATUS.ordinal()] = true;
            }
            this.layer.addStatusListener(l);
        }

        @Override
        public synchronized void removeStatusListener(StatusListens l) {
            this.layer.removeStatusListener(l);
        }

        @Override
        public synchronized void addLogListener(LogListener l) {
            if (!this.registered[Bus.LOG.ordinal()]) {
                try {
                    this.layer.registerToLog();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.registered[Bus.LOG.ordinal()] = true;
            }
            this.layer.addLogListener(l);
        }

        @Override
        public synchronized void removeLogListener(LogListener l) {
            this.layer.removeLogListener(l);
        }

        @Override
        public void addCommandListener(CommandListener l, String selector) {
            this.addCommandListener(l);
        }

        @Override
        public void addStatusListener(StatusListens l, String selector) {
            this.addStatusListener(l);
        }

        @Override
        public void addLogListener(LogListener l, String selector) {
            this.addLogListener(l);
        }

        @Override
        public synchronized void sendCommand(Command cmd) {
            try {
                if (!this.registered[Bus.COMMAND.ordinal()]) {
                    this.layer.registerToCommand();
                    this.registered[Bus.COMMAND.ordinal()] = true;
                }
                this.layer.sendCommand(cmd);
            }
            catch (IOException e) {
                if (e instanceof DestinationsException) {
                    BusMessagingFactory.this.curLogger.warn((Object)"destination problem", (Throwable)e, new String[0]);
                    throw new RuntimeException(e);
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public synchronized void sendStatus(Status status) {
            try {
                if (!this.registered[Bus.STATUS.ordinal()]) {
                    this.layer.registerToStatus();
                    this.registered[Bus.STATUS.ordinal()] = true;
                }
                this.layer.sendStatus(status);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public synchronized void sendLogEvent(LogEvent evt) {
            try {
                if (!this.registered[Bus.LOG.ordinal()]) {
                    this.layer.registerToLog();
                    this.registered[Bus.LOG.ordinal()] = true;
                }
                this.layer.sendLogEvent(evt);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getToken() {
            return this.layer.getToken();
        }

        @Override
        public void reply(CommandAckOrReply cmd) {
            try {
                this.layer.reply(cmd);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void noAutoReply() {
            this.autoReply = false;
        }

        @Override
        public boolean isReplyRequested() {
            return this.autoReply;
        }

        @Override
        public void shutdownBusAccess() {
            this.layer.close();
            int ix = 0;
            while (ix < this.registered.length) {
                this.registered[ix] = false;
                ++ix;
            }
        }

        @Override
        public List<String> connectedToCommand() {
            return this.layer.connectedToCommand();
        }

        @Override
        public synchronized void addMembershipListener(BusMembershipListener l) {
            this.layer.addMembershipListener(l);
        }

        @Override
        public synchronized void removeMembershipListener(BusMembershipListener l) {
            this.layer.removeMembershipListener(l);
        }
    }
}

