package org.lsst.ccs.bus;

/**
* to be implemented by codes that want to receive all status messages .
 * It will not receive <TT>EncodedDataStatus</TT> messages if the code also implements
 * one of the <TT>EncodedStatusListens</TT> interface.
 * </BR>
 * It could be one of <TT>KeyValueListener</TT> (objects are split into key-values), <TT>DataStatusListener</TT>
 *  (Objects are rebuilt if the class is known to the current ClassLoader), <TT>SerializedDataStatusListener</TT>
 * (Objects are serialized in a byte array) or <TT>NoDataStatusListener</TT> (<TT>EncodedDataStatus</TT>
 *  are discarded).
 */
public interface StatusListener extends StatusListens{
	void onStatus(BusMessage s);
}
