/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.framework;

import org.apache.log4j.PropertyConfigurator;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.utilities.tracers.Tracer;

import java.io.*;
import java.util.Iterator;
import java.util.Properties;

/**
 * default log4J properties are set here.
 * <BR/>
 * Modified (bamade) to forward calls to our <TT>JULAppender</TT>
 * @author turri
 */
@Deprecated
public class FrameworkUtils {

    static {
        try {

            Properties defaultLog4JProperties = new Properties();
            defaultLog4JProperties.setProperty("log4j.rootLogger", "info, stdout");
             defaultLog4JProperties.setProperty("log4j.appender.julAppender", "org.lsst.ccs.utilities.logging.JULAppender") ;
            //defaultLog4JProperties.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
           defaultLog4JProperties.setProperty("log4j.appender.stdout", "org.lsst.ccs.utilities.logging.JULAppender");
            defaultLog4JProperties.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
            defaultLog4JProperties.setProperty("log4j.appender.julAppender.layout", "org.apache.log4j.PatternLayout");
            defaultLog4JProperties.setProperty("log4j.appender.stdout.layout.ConversionPattern", "%d{ISO8601} - %m%n");
            defaultLog4JProperties.setProperty("log4j.logger.lsst", "error");
            defaultLog4JProperties.setProperty("log4j.logger.lsst.ccs.Subsystem", "error");
            defaultLog4JProperties.setProperty("log4j.logger.org.springframework.aop", "error");
            defaultLog4JProperties.setProperty("log4j.logger.org.springframework", "error");
            defaultLog4JProperties.setProperty("log4j.logger.lsst.ccs.framework", "error");
            String userProps = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("lsst.ccs.logging.log4j") ;
            if(userProps != null) {
                String[] keyVals = userProps.split(":");
                try {
                for(String keyVal : keyVals) {
                    String[] kvs = keyVal.split("=") ;
                    String key = kvs[0] ;
                    String value = kvs[1] ;
                    if("rootLogger".equals(key)) {
                        defaultLog4JProperties.setProperty("log4j." + key, value)  ;
                    } else {
                        defaultLog4JProperties.setProperty("log4j.logger." + key, value)  ;
                    }
                }
                } catch(Exception exc) {
                    //TODO: not logged!
                    System.err.println("problem with ccc.logging.log4j : " + exc);
                }
            }

            PropertyConfigurator.configure(loadProperties(defaultLog4JProperties, FrameworkUtils.class, "log4j.properties"));
        } catch (Exception e) {
            System.out.println("#### Cannot load Log4J properties file");
        }
    }

    public static Properties getDefaultJndiProperties() {
        Properties defaultJndiProperties = new Properties();
        defaultJndiProperties.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        defaultJndiProperties.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        defaultJndiProperties.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.remote.JNDIStateFactoryImpl");
        defaultJndiProperties.setProperty("org.omg.CORBA.ORBInitialHost", "localhost");
        defaultJndiProperties.setProperty("org.omg.CORBA.ORBInitialPort", "3700");
        return defaultJndiProperties;
    }

    public static InputStream getConfigFileInputStream(String configFile) {
        InputStream configFileInputStream = null;
        // First try loading the file from the file system
        try {
            configFileInputStream = new FileInputStream(configFile);
            assert Tracer.trace("Loading Config File " + configFile + " from File System");
            //System.out.println("Loading Config File " + configFile + " from File System");
            return configFileInputStream;
        } catch (FileNotFoundException fnfe) {
        }

        // Try loading the file as a Resource from the classpath
        configFileInputStream = FrameworkUtils.class.getResourceAsStream(configFile);
        if (configFileInputStream != null) {
            assert Tracer.trace("Loading Config File " + configFile + " from Classpath");
            //System.out.println("Loading Config File " + configFile + " from Classpath");
        }

        return configFileInputStream;
    }

    public static Properties loadProperties(Properties defaultProperties, Class clazz, String fileName) {

        Properties cloneProperties = defaultProperties == null ? new Properties() : new Properties(defaultProperties);

        InputStream is = null;
        if (clazz != null && fileName != null) {
            is = clazz.getResourceAsStream(fileName);
            if (is != null) {
                assert Tracer.trace("*** Loading properties from " + fileName + " in Classpath.");
                //System.out.println("*** Loading properties from " + fileName + " in Classpath.");
                try {
                    cloneProperties.load(is);
                } catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }

        if (fileName != null) {
            String resourcesDir = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.resources.directory", null);
            String fileSeparator = System.getProperty("file.separator");
            if (resourcesDir != null) {
                if (!resourcesDir.endsWith(fileSeparator)) {
                    resourcesDir += fileSeparator;
                }
                if (fileName.startsWith(fileSeparator)) {
                    fileName = fileName.substring(1);
                }
                fileName = resourcesDir + fileName;
            }

            File propertiesFile = new File(fileName);
            if (propertiesFile.exists()) {
                assert Tracer.trace("*** Loading properties from file " + fileName);
                //System.out.println("*** Loading properties from file " + fileName);
                try {
                    cloneProperties.load(new FileInputStream(propertiesFile));
                } catch (IOException ioe) {
                    //TODO: WrappedException
                    throw new RuntimeException(ioe);
                }
            }
        }

        Properties sysProperties = BootstrapResourceUtils.getBootstrapSystemProperties();
        Iterator iter = BootstrapResourceUtils.getAllKeysInProperties(sysProperties).iterator();
        while (iter.hasNext()) {
            String key = (String) iter.next();
            cloneProperties.put(key, sysProperties.getProperty(key));
        }

        return cloneProperties;
    }
}
