package org.lsst.ccs.bus;

import java.util.ArrayList;
import java.util.ServiceLoader;

/**
 */
public abstract class TransportManager {
    static ArrayList<TransportManager> transportManagers = new ArrayList<TransportManager>() ;
    
    static {
        ServiceLoader<TransportManager> loader = ServiceLoader.load(TransportManager.class) ;
        for(TransportManager transportManager : loader) {
            transportManagers.add(transportManager) ;
        }
    }

    public static BusMessagingLayer getConnection(String protocolstring, String propertiesString) 
        throws TransportException{
        for(TransportManager manager : transportManagers) {
            BusMessagingLayer transport = manager.getInstance(protocolstring, propertiesString) ;
            if(transport != null) {
                transport.setMembershipListener(new DefaultLogMembershipListener());
                return transport ;
            }
        }
        throw new TransportException(protocolstring) ;
    }
    
    public abstract BusMessagingLayer getInstance(String protocolString, String propertiesString) ;
}
