package org.lsst.ccs.bus;


//import org.apache.log4j.Logger;


import org.lsst.ccs.utilities.logging.Logger;

/**
 * this is to distinguish the transport layer for message from their Application layer.
 * This code I do not understand is copied from JMSMessagingFactory with extraction
 * of what should be relevant to the application layer!!
 * <P>
 *     SPECS TO BE IMPLEMENTED:
 *     <BR>
 *     each Subsystems should have its own Application layer (an instance for each subsystem).
 *     <BR>
 *         this instance deals with  linking command/response and data that links subsystem name with
 *         routing  data for the transport layer
 *      <BR>
 *          the fact that the transport layer is a singleton should be transparent
 *          (for instance in Jgroups this is not the case! each subssystem can have its own Address on the net!)
 *      </BR>
 *     </BR>
 *     So this class should be dumped and MessagingFactroy changed
 *     the messaging should be a protected member of subsystem
 * </P>
 * @author bamade
 */
public class MessagingApplicationLayer {
    Logger logger = Logger.getLogger("org.lsst.ccs.bus.layer") ;
    ///////// COPIED FROM JMS
    // Thread local pattern assumes reply will be send on same thread
    // will not handle deferred executions of commands.
    // thread local context is only set when receiving a message
    // JMS specific : ThreadLocal<String> localCorrelID = new ThreadLocal<String>();
    // JMS sepcificThreadLocal<String> localReplyTo = new ThreadLocal<String>();// changed Destination to String
    ThreadLocal<String> localOrigin = new ThreadLocal<String>();
    ThreadLocal<Command> localCommand = new ThreadLocal<Command>();
    String token = java.util.UUID.randomUUID().toString(); // for arbitrator

    // should be set to "MAIN" for the main control module that holds all locks
    // initially
    // TODO (at the moment default value for subsystem allows any command)
    public String getToken() {
        return token;
    }

    volatile boolean replyRequested = true ;
    public boolean isReplyRequested() {
        //return localReplyTo.get() != null;
        //TODO: ??????
        return replyRequested ;
    }


    public void noAutoReply() {
        //localReplyTo.set(null);
    }
    /////////////////////////////////////// COPIED FROM JMS

    // COMMAND INITIATING SIDE

    /**
     * the command id tagged with a token, an origin, and a correlation
     * @param cmd
     * @return
     */
    public Command commandForSending(Command cmd) {
         cmd.setKey(token);
        cmd.setOrigin(MessagingFactory.getInstance().getSubsystemName());
        // @TODO: is this relevant? not sure at all!! probalby a bug in JMSMessagingFactory
        /*.
        if (cmd.getCorrelId() == null) {
            cmd.setCorrelId(localCorrelID.get());
        }
        */
        if (cmd.getCorrelId() == null) {
            // let's generate one
            cmd.setCorrelId(java.util.UUID.randomUUID().toString());
        }
        return cmd ;
    }


    /**
     * if you are not the one who initiated the command, ditch it!
     * it means that CommandReply should have a destination !
     * is this a transport or an application layer problem?
     * @param reply
     * @return null if this is not for you!
     */
    public CommandAckOrReply receivingReply(CommandAckOrReply reply) {
        // does not deal with threadLocal things! (or so I think!)
        // ALAS it does!
        String local = MessagingFactory.getInstance().getSubsystemName();
        if(local == null) {
            logger.warn("TODO: modify subsystem name knowledge (BUG)");
            return reply ;
        }
        Command command =reply.getOriginalCommand();
        if (command == null) {
            logger.warn("null command in reply");
            return reply ;
        }
        if(local.equals(command.getOrigin())) {
            return reply ;
        }
        // @TODO : check!
        logger.warn("!!!!!! LOST REPLY!");
        return reply ;
    }
    // END INITIATIVE

    // INVOLVED SIDE : BEWARE OF THREAD ISSUES receiving a command and replying should be handled by
    // a single Thread
    // these methods SHOULD BE CALLED inside that Thread (nor before dispatching to other threads!)
    public Command receivingCommand(Command command) {
        localOrigin.set(command.getOrigin());
        localCommand.set(command);
        return command ;
    }
    /**
     * this method shoudl be modified to us a transport layer information to be returned
     *
     * @param reply
     * @return
     */
    public CommandAckOrReply replyForSending(CommandAckOrReply reply) {
        // String dest = localReplyTo.get();
        String destSystem = localOrigin.get();
        logger.info("REPLY destination:" + destSystem);


        reply.setOriginalCommand(localCommand.get());
        //@TODO: CHANGE THAT!!!!!
        //localCommand.set(null);
        //localOrigin.set(null);
        if (reply.getCorrelId() == null) {
            // WAS : reply.setCorrelId(localCorrelID.get());
            Command originalCommand = reply.getOriginalCommand() ;
            if(originalCommand != null) {
            reply.setCorrelId(reply.getOriginalCommand().getCorrelId());
            } else {
                reply.setCorrelId("no command correlation");
            }
        }
        reply.setOrigin(MessagingFactory.getInstance().getSubsystemName());
        return reply ;
    }

    /// END COMMANDS

    public Status statusForSending(Status status) {
        return status ;
    }

    public LogEvent logForSending(LogEvent log) {
        return log ;
    }


    public Status receivingStatus(Status status) {
        return status ;
    }

    public LogEvent receivingLog(LogEvent log) {
        return log ;
    }

}
