/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.LogListener;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusListener;

public abstract class MessagingFactory {
    protected static volatile MessagingFactory instance;
    private String subsystemName;

    public static synchronized MessagingFactory getInstance() {
        if (instance == null) {
            MessagingFactory.instanciate();
        }
        return instance;
    }

    protected static void instanciate() {
        String clazz = System.getProperty("lsst.messaging.factory", "org.lsst.ccs.bus.BusMessagingFactory");
        try {
            instance = (MessagingFactory)Class.forName(clazz).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MessagingFactory forSubsystem(String subsystemName) {
        this.subsystemName = subsystemName;
        return this;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    public abstract void addCommandListener(CommandListener var1);

    public abstract void addStatusListener(StatusListener var1);

    public abstract void addLogListener(LogListener var1);

    public abstract void addCommandListener(CommandListener var1, String var2);

    public abstract void addStatusListener(StatusListener var1, String var2);

    public abstract void addLogListener(LogListener var1, String var2);

    public abstract void sendCommand(Command var1);

    public abstract void sendStatus(Status var1);

    public abstract void sendLogEvent(LogEvent var1);

    public abstract String getToken();

    public abstract void reply(CommandAckOrReply var1);

    public boolean isReplyRequested() {
        return false;
    }

    public abstract void noAutoReply();

    public void shutdownBusAccess() {
    }
}

