package org.lsst.ccs.bus;


/**
 * Messaging factory, insulating the application from the messaging middleware
 * (JMS or other)
 *
 * @author aubourg
 */

public abstract class MessagingFactory {
    protected volatile static MessagingFactory instance;

    //@TODO: should be getInstance( String subsystemName)
    public static synchronized MessagingFactory getInstance() {
        if (instance == null) {
            instanciate();
        }
        return instance;
    }

    protected static void instanciate() {
        String clazz = System.getProperty("lsst.messaging.factory", "org.lsst.ccs.bus.BusMessagingFactory");
        try {
            instance = (MessagingFactory) Class.forName(clazz).newInstance();
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        } catch (Exception e) { //@modified (bamade) : for other crashes
            throw new RuntimeException(e);
        }
    }
    
    //todo: change that (added by bamade)
    
    private String subsystemName;

    public  MessagingFactory forSubsystem(String subsystemName) {
	this.subsystemName=subsystemName;
        return this ;
    }

    public String getSubsystemName() {
	return subsystemName;
    }

    public abstract void addCommandListener(CommandListener l);
    public abstract void removeCommandListener(CommandListener l);

    public abstract void addStatusListener(StatusListener l);
    public abstract void removeStatusListener(StatusListener l);

    public abstract void addLogListener(LogListener l);
    public abstract void removeLogListener(LogListener l);

    public abstract void addCommandListener(CommandListener l, String selector);

    public abstract void addStatusListener(StatusListener l, String selector);

    public abstract void addLogListener(LogListener l, String selector);

    public abstract void sendCommand(Command cmd);

    // TODO sendCommandSync qui retourne un Reply

    public abstract void sendStatus(Status status);

    public abstract void sendLogEvent(LogEvent evt);

    public abstract String getToken();

    /* has to be called on the same thread as the command */
    public abstract void reply(CommandAckOrReply cmd);

    public boolean isReplyRequested() {
        return false;
    }

    public abstract void noAutoReply();
    //@modified (bamade) -> @TODO: add a close() method to stop listening threads!
    public void shutdownBusAccess() {

    }

}
