/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.util.ArrayList;
import java.util.ServiceLoader;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.DefaultLogMembershipListener;
import org.lsst.ccs.bus.TransportException;

public abstract class TransportManager {
    static ArrayList<TransportManager> transportManagers = new ArrayList();

    static {
        ServiceLoader<TransportManager> loader = ServiceLoader.load(TransportManager.class);
        for (TransportManager transportManager : loader) {
            transportManagers.add(transportManager);
        }
    }

    public static BusMessagingLayer getConnection(String protocolstring, String propertiesString) throws TransportException {
        for (TransportManager manager : transportManagers) {
            BusMessagingLayer transport = manager.getInstance(protocolstring, propertiesString);
            transport.setMembershipListener(new DefaultLogMembershipListener(), new Bus[0]);
            if (transport == null) continue;
            return transport;
        }
        throw new TransportException(protocolstring);
    }

    public abstract BusMessagingLayer getInstance(String var1, String var2);
}

