/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.BusMessageForwarder;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.LogListener;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusListener;

public class BusApplicationLayer {
    protected final String subsystemName;
    protected final BusMessagingLayer busMessagingLayer;
    protected static Logger log = Logger.getLogger((String)"lsst.ccs.subsystem");
    protected ThreadLocal<String> localCorrelID = new ThreadLocal();
    protected ThreadLocal<String> localOrigin = new ThreadLocal();
    protected ThreadLocal<Command> localCommand = new ThreadLocal();
    String token = UUID.randomUUID().toString();

    public BusApplicationLayer(String subsystemName, BusMessagingLayer busMessagingLayer) {
        this.subsystemName = subsystemName;
        this.busMessagingLayer = busMessagingLayer;
    }

    public String getToken() {
        return this.token;
    }

    public void registerToCommand() throws IOException {
        this.busMessagingLayer.register(this.subsystemName, Bus.COMMAND);
    }

    public void registerToStatus() throws IOException {
        this.busMessagingLayer.register(this.subsystemName, Bus.STATUS);
    }

    public void registerToLog() throws IOException {
        this.busMessagingLayer.register(this.subsystemName, Bus.LOG);
    }

    protected String[] parseDestination(String destination) {
        String[] dests = destination.split(",");
        int ix = 0;
        while (ix < dests.length) {
            String dest = dests[ix];
            if ("*".equals(dest)) {
                dests = new String[]{};
                break;
            }
            if (dest.contains("/")) {
                dests[ix] = dest.substring(0, dest.indexOf("/"));
            }
            ++ix;
        }
        return dests;
    }

    public void sendCommand(Command cmd) throws IOException {
        String[] destinations = this.parseDestination(cmd.getDestination());
        cmd.setKey(this.token);
        if (cmd.getOrigin() == null) {
            cmd.setOrigin(this.subsystemName);
        }
        if (cmd.getCorrelId() == null) {
            cmd.setCorrelId(UUID.randomUUID().toString());
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.COMMAND, cmd, destinations);
    }

    public void sendStatus(Status status) throws IOException {
        if (status.getOrigin() == null) {
            status.setOrigin(this.subsystemName);
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.STATUS, status, new String[0]);
    }

    public void sendLogEvent(LogEvent evt) throws IOException {
        if (evt.getOrigin() == null) {
            evt.setOrigin(this.subsystemName);
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.LOG, evt, new String[0]);
    }

    public void reply(CommandAckOrReply cmd) throws IOException {
        String destination;
        if (cmd.getOriginalCommand() == null) {
            cmd.setOriginalCommand(this.localCommand.get());
        }
        if (cmd.getOrigin() == null) {
            cmd.setOrigin(this.subsystemName);
        }
        if (cmd.getCorrelId() == null) {
            cmd.setCorrelId(this.localCorrelID.get());
        }
        if ((destination = cmd.getDestination()) == null) {
            destination = this.localOrigin.get();
            cmd.setDestination(destination);
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.COMMAND, cmd, destination);
    }

    public void addCommandListener(CommandListener l) {
        this.busMessagingLayer.addMessageListener(this.subsystemName, new ForwarderToCommand(l), Bus.COMMAND);
    }

    public void addStatusListener(StatusListener l) {
        this.busMessagingLayer.addMessageListener(this.subsystemName, new ForwarderToStatus(l), Bus.STATUS);
    }

    public void addLogListener(LogListener l) {
        this.busMessagingLayer.addMessageListener(this.subsystemName, new ForwarderToLog(l), Bus.LOG);
    }

    public void close() {
        this.busMessagingLayer.closeFor(this.subsystemName, new Bus[0]);
    }

    protected class ForwarderToCommand
    implements BusMessageForwarder {
        CommandListener listener;

        ForwarderToCommand(CommandListener listener) {
            this.listener = listener;
        }

        @Override
        public void update(BusMessage message) {
            if (message instanceof CommandReply) {
                this.listener.onReply((CommandReply)message);
            } else if (message instanceof CommandAck) {
                this.listener.onAck((CommandAck)message);
            } else if (message instanceof Command) {
                Command cmd = (Command)message;
                BusApplicationLayer.this.localCommand.set(cmd);
                BusApplicationLayer.this.localOrigin.set(cmd.getOrigin());
                BusApplicationLayer.this.localCorrelID.set(cmd.getCorrelId());
                try {
                    this.listener.onCommand(cmd);
                }
                catch (Throwable throwable) {
                    log.error((Object)("on command :" + throwable));
                }
            }
        }
    }

    protected class ForwarderToLog
    implements BusMessageForwarder {
        LogListener listener;

        ForwarderToLog(LogListener listener) {
            this.listener = listener;
        }

        @Override
        public void update(BusMessage message) {
            if (message instanceof LogEvent) {
                this.listener.onLog((LogEvent)message);
            }
        }
    }

    protected class ForwarderToStatus
    implements BusMessageForwarder {
        StatusListener listener;

        ForwarderToStatus(StatusListener listener) {
            this.listener = listener;
        }

        @Override
        public void update(BusMessage message) {
            this.listener.onStatus(message);
        }
    }
}

