/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.lsst.ccs.utilities.tracers.Tracer;

public class FrameworkUtils {
    static {
        try {
            Properties defaultLog4JProperties = new Properties();
            defaultLog4JProperties.setProperty("log4j.rootLogger", "info, stdout");
            defaultLog4JProperties.setProperty("log4j.appender.julAppender", "org.lsst.ccs.utilities.logging.JULAppender");
            defaultLog4JProperties.setProperty("log4j.appender.stdout", "org.lsst.ccs.utilities.logging.JULAppender");
            defaultLog4JProperties.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
            defaultLog4JProperties.setProperty("log4j.appender.julAppender.layout", "org.apache.log4j.PatternLayout");
            defaultLog4JProperties.setProperty("log4j.appender.stdout.layout.ConversionPattern", "%d{ISO8601} - %m%n");
            defaultLog4JProperties.setProperty("log4j.logger.lsst", "error");
            defaultLog4JProperties.setProperty("log4j.logger.lsst.ccs.Subsystem", "error");
            defaultLog4JProperties.setProperty("log4j.logger.org.springframework.aop", "error");
            defaultLog4JProperties.setProperty("log4j.logger.org.springframework", "error");
            defaultLog4JProperties.setProperty("log4j.logger.lsst.ccs.framework", "error");
            String userProps = System.getProperty("lsst.ccs.logging.log4j");
            if (userProps != null) {
                String[] keyVals = userProps.split(":");
                try {
                    String[] stringArray = keyVals;
                    int n = keyVals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String keyVal = stringArray[n2];
                        String[] kvs = keyVal.split("=");
                        String key = kvs[0];
                        String value = kvs[1];
                        if ("rootLogger".equals(key)) {
                            defaultLog4JProperties.setProperty("log4j." + key, value);
                        } else {
                            defaultLog4JProperties.setProperty("log4j.logger." + key, value);
                        }
                        ++n2;
                    }
                }
                catch (Exception exc) {
                    System.err.println("problem with ccc.logging.log4j : " + exc);
                }
            }
            PropertyConfigurator.configure((Properties)FrameworkUtils.loadProperties(defaultLog4JProperties, FrameworkUtils.class, "log4j.properties"));
        }
        catch (Exception exception) {
            System.out.println("#### Cannot load Log4J properties file");
        }
    }

    public static Properties getDefaultJndiProperties() {
        Properties defaultJndiProperties = new Properties();
        defaultJndiProperties.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        defaultJndiProperties.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        defaultJndiProperties.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.remote.JNDIStateFactoryImpl");
        defaultJndiProperties.setProperty("org.omg.CORBA.ORBInitialHost", "localhost");
        defaultJndiProperties.setProperty("org.omg.CORBA.ORBInitialPort", "3700");
        return defaultJndiProperties;
    }

    public static InputStream getConfigFileInputStream(String configFile) {
        InputStream configFileInputStream = null;
        try {
            configFileInputStream = new FileInputStream(configFile);
            assert (Tracer.trace((String)("Loading Config File " + configFile + " from File System")));
            return configFileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            configFileInputStream = FrameworkUtils.class.getResourceAsStream(configFile);
            if (configFileInputStream != null) assert (Tracer.trace((String)("Loading Config File " + configFile + " from Classpath")));
            return configFileInputStream;
        }
    }

    public static Properties loadProperties(Properties defaultProperties, Class clazz, String fileName) {
        Properties cloneProperties = defaultProperties == null ? new Properties() : new Properties(defaultProperties);
        InputStream is = null;
        if (clazz != null && fileName != null && (is = clazz.getResourceAsStream(fileName)) != null) {
            assert (Tracer.trace((String)("*** Loading properties from " + fileName + " in Classpath.")));
            try {
                cloneProperties.load(is);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        if (fileName != null) {
            File file;
            String resourcesDir = System.getProperty("org.lsst.ccs.resources.directory", null);
            String fileSeparator = System.getProperty("file.separator");
            if (resourcesDir != null) {
                if (!resourcesDir.endsWith(fileSeparator)) {
                    resourcesDir = String.valueOf(resourcesDir) + fileSeparator;
                }
                if (fileName.startsWith(fileSeparator)) {
                    fileName = fileName.substring(1);
                }
                fileName = String.valueOf(resourcesDir) + fileName;
            }
            if ((file = new File(fileName)).exists()) {
                assert (Tracer.trace((String)("*** Loading properties from file " + fileName)));
                try {
                    cloneProperties.load(new FileInputStream(file));
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
        Properties sysProperties = System.getProperties();
        for (String string : sysProperties.keySet()) {
            cloneProperties.put(string, sysProperties.getProperty(string));
        }
        return cloneProperties;
    }
}

