/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.messaging.util.MultiQueueDispatcher;
import org.lsst.ccs.messaging.util.Throttle;

public class ThrottleTest {
    @BeforeAll
    public static void setUpClass() {
    }

    @AfterAll
    public static void tearDownClass() {
    }

    @BeforeEach
    public void setUp() {
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testProcess() {
        Random rand = new Random();
        byte[] b1 = new byte[1000000];
        rand.nextBytes(b1);
        Message m1 = new Message(b1);
        byte[] b2 = new byte[2000000];
        rand.nextBytes(b2);
        Message m2 = new Message(b2);
        byte[] b3 = new byte[3000000];
        rand.nextBytes(b3);
        Message m3 = new Message(b3);
        byte[] b4 = new byte[4000000];
        rand.nextBytes(b4);
        Message m4 = new Message(b4);
        byte[] b6 = new byte[6000000];
        rand.nextBytes(b6);
        Message m6 = new Message(b6);
        byte[] b10 = new byte[10000000];
        rand.nextBytes(b10);
        Message m10 = new Message(b10);
        ArrayList<Long> out = new ArrayList<Long>(100);
        MultiQueueDispatcher d = new MultiQueueDispatcher("");
        Throttle throttle = new Throttle((Dispatcher)d, "AlertID", 5, 30);
        this.mark(out);
        throttle.process((BusMessage)m1);
        this.mark(out);
        throttle.process((BusMessage)m2);
        this.mark(out);
        throttle.process((BusMessage)m3);
        this.mark(out);
        throttle.process((BusMessage)m1);
        this.mark(out);
        throttle.process((BusMessage)m6);
        this.mark(out);
        LockSupport.parkNanos(100000000L);
        throttle.process((BusMessage)m4);
        this.mark(out);
        this.check(out, new int[]{0, 0, 33, 33, 200, 133});
    }

    private void mark(List<Long> out) {
        out.add(System.nanoTime());
    }

    private void check(List<Long> out, int[] expected) {
        for (int i = 0; i < expected.length; ++i) {
            int delay = (int)(out.get(i + 1) - out.get(i)) / 1000000;
            Assert.assertTrue((String)("Delay " + i + ": expected " + expected[i] + ", actual " + delay), (Math.abs(expected[i] - delay) < 50 ? 1 : 0) != 0);
        }
        out.clear();
    }

    private static class Message
    extends BusMessage<Serializable, Serializable> {
        Message(byte[] data) {
            super(Serializable.class, data, "none");
        }

        protected Serializable encodeObject(Serializable obj) {
            return obj;
        }
    }
}

