package org.lsst.ccs.messaging;

/**
 * Manages the creation of the messaging layer implementations.
 * Internally it uses the ServiceLoader architecture to find the proper bus implementation
 * @author emarin
 */
public interface MessagingManager {
    
    /**
     * Creates an instance of the bus messaging layer.
     * The underlying implementation is chosen based on the provided protocol string.
     * If this method is invoked more than once within the same JVM (for the same protocol string), it is up to the underlying implementation
     * to choose whether to return the same instance or not
     * @param protocol The protocol to choose the implementation of the buses.
     * @return the messaging layer
    */
    public MessagingLayer createMessagingLayer(String protocol);
    
}
