package org.lsst.ccs.bus.jms;

//import org.apache.log4j.Logger;
import org.lsst.ccs.bus.*;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.JMSContext;
import static org.lsst.ccs.bus.BusMessagingLayer.ANONYMOUS_AGENT;

/**
 */
public class JMSBusMessagingLayer implements BusMessagingLayer {
     private static org.lsst.ccs.utilities.logging.Logger logger = org.lsst.ccs.utilities.logging.Logger.getLogger("org.lsst.ccs.bus.jms.JMSBusMessagingLayer");
    
    private Map<String, LocalAgent> mapLocalAgent = new ConcurrentHashMap<>();
    
    class LocalAgent{
        String agentName;
        JMSContext jmsContext;
        JMSConsumer[] consumers = new JMSConsumer[Bus.values().length];
        BusReceiver[] receivers = new BusReceiver[Bus.values().length];
    }
    
    class  BusReceiver implements MessageListener{
        
        Bus bus;
        //todo: duplicate information
        JMSConsumer curConsumer;
        //ParallelCommandDispatcher dispatcher;
        CopyOnWriteArrayList<BusMessageForwarder> listForwarders;
        //todo: again a duplicate!
        String agentName;
        
        public BusReceiver(String agentName, Bus bus, JMSConsumer curConsumer) throws JMSException {
            this.agentName = agentName;
            this.bus = bus;
            this.curConsumer = curConsumer;
            curConsumer.setMessageListener(this);
        }
        
        public void addForwarder(BusMessageForwarder forwarder) {
            //TODO: reinstall Parallel ?
            /*
            if (dispatcher == null) {
            dispatcher = new ParallelCommandDispatcher();
            }
            dispatcher.addExecutant(forwarder);
            */
            if (listForwarders == null) {
                listForwarders = new CopyOnWriteArrayList<BusMessageForwarder>();
            }
            listForwarders.add(forwarder);
        }
        
        public void removeForwarder(BusMessageForwarder forwarder) {
            /*
            if (dispatcher == null) return;
            dispatcher.removeExecutant(forwarder);
            */
            if (listForwarders == null) {
                return;
            }
            listForwarders.remove(forwarder);
        }
        
        @Override
        public void onMessage(Message message) {
            
            BusMessage busMessInit=null;
            try {
                if (listForwarders == null) {
                    return;
                }
                if (listForwarders.isEmpty()) {
                    return;
                }
//                if (bus == Bus.COMMAND && message.propertyExists("destination")){
//                    // split the string
//                    String[] array = message.getStringProperty("destination").split(" ");
//
//
//                }
                try {
                    busMessInit = (BusMessage) ((ObjectMessage)message).getObject();
                } catch (JMSException ex) {
                    logger.error(JMSBusMessagingLayer.class.getName());
                }
            } catch (final RuntimeException exc) {
                throw exc;
                //TODO: create a generic Message for reporting errors
                /* busMessInit = new BusMessage() {
                @Override
                public String getMessageType() {
                return "error" + exc;
                }
                } ;
                */
            }
            final BusMessage busMess = busMessInit;
            if (busMess.getOrigin().equals(agentName)) {
                logger.trace("message received by same agent than sender");
                return;
            }
            // TODO : reinstall parallel
            for (BusMessageForwarder forwarder : listForwarders) {
                forwarder.update(busMess);
            }
        }
    }
    
    // Close the entire local connections
    @Override
    public void close() throws IOException {
        Iterator<String> itKeys = mapLocalAgent.keySet().iterator();
        while (itKeys.hasNext()) {
            String key = itKeys.next();
            logger.info("******** removing " + key);
            LocalAgent localAgent = mapLocalAgent.get(key);
            for (JMSConsumer mc : localAgent.consumers) {
                if (mc != null) {
                    mc.close();
                }
            }
            //updateConnectionsMap();
            // TODO : Do we need to destroy the connection itself ?
        }
    }
    
    @Override
    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus... buses) {

        if (agentName == null || "".equals(agentName)) {
            agentName = ANONYMOUS_AGENT;
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        
        for (Bus bus : buses){
            BusReceiver receiver  = mapLocalAgent.get(agentName).receivers[bus.ordinal()];
            if (receiver == null) {
                throw new IllegalArgumentException(" agent " + agentName + "not registered on bus " + bus);
            }
            receiver.addForwarder(forwarder);
        }
    }
    
    @Override
    public void closeFor(String agentName, Bus... buses) {
        if (agentName == null || "".equals(agentName)) {
            agentName = ANONYMOUS_AGENT;
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        LocalAgent localAgent = mapLocalAgent.get(agentName);
        if (localAgent != null){
            for (Bus b : buses){
                int index = b.ordinal();
                localAgent.consumers[index].close();
                localAgent.jmsContext.unsubscribe(agentName);
            }
        }
       // updateConnectionsMap();
    }
    
    @Override
    public <T extends BusPayload> void sendMessage(String senderAgent, Bus<T> bus, T message, String... destinations) throws IOException {
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        int index = bus.ordinal();
        
        JMSContext ctxt = mapLocalAgent.get(senderAgent).jmsContext;
        JMSProducer send = ctxt.createProducer();
        
        
        if (bus == Bus.COMMAND && destinations.length != 0){
            for (String dest : destinations){
                sendMessageToDestination(ctxt, message, dest, send, bus);
            }
        }
        else {
            sendMessageToDestination(ctxt, message, "", send, bus);
        }
    }
    
    public <T extends BusPayload> void sendMessageToDestination(JMSContext ctxt, T message, String dest, JMSProducer send, Bus<T> bus){
        ObjectMessage m;
        try {
            m = ctxt.createObjectMessage();
            m.setObject(message);
            //m.setJMSType(message.getMessageType());
            if (!dest.isEmpty()){
                m.setStringProperty("destination", dest);
            }
            //m.setJMSPriority(convertToJMSPriority(message.getPriorityLevel()));
            //if (message.getCorrelId() != null) {
            //    m.setJMSCorrelationID(cmd.getCorrelId());
            //}
            
        } catch (JMSException e) {
            logger.error(e);
            throw new RuntimeException(e);
        }
        try {
            // if (m.getJMSCorrelationID() == null) {
            //     m.setJMSCorrelationID(localCorrelID.get());
            // }
            m.setJMSMessageID("0"); /* TODO handle messageid */
            m.setJMSPriority(4); // 0-4 normal, 4-9 expedited
            
            // uncomment to send replies on the command topic
            
            m.setJMSReplyTo(TopicContextFactory.getTopicContextFactory().getCommandTopic());
            
            m.setJMSTimestamp(System.currentTimeMillis());
            String busName = bus.toString();
            
            send.send(TopicContextFactory.getTopicContextFactory().getTopic(busName), m);
            //   send.
        } catch (JMSException e) {
            logger.error("Error sending message", e);
            throw new RuntimeException(e);
        }
    }
    
    @Override
    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus... buses) {
        if (agentName == null || "".equals(agentName)) {
            agentName = ANONYMOUS_AGENT;
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        LocalAgent localAgent = mapLocalAgent.get(agentName);
        if (localAgent == null) {
            return;
        }
        for (Bus bus : buses) {
            BusReceiver receiver = localAgent.receivers[bus.ordinal()];
            if (receiver == null) {
                continue;
            }
            receiver.removeForwarder(forwarder);
        }
    }
    
    @Override
    public void register(String agentName, Bus... buses) throws IOException {
        
        if (agentName == null || "".equals(agentName)) {
            agentName = ANONYMOUS_AGENT;
        }
        
        StringBuilder allBuses = new StringBuilder();
        for (Bus bus : buses) {
            allBuses.append(bus.toString()).append(" ");
        }
        logger.info("### Registering " + agentName + " for buses " + allBuses);
        
        
        if (buses.length == 0){
            buses = Bus.values();
        }
        
        // Is this agent known to the map ?
        LocalAgent localAgent = mapLocalAgent.get(agentName);
        if (localAgent == null){
            localAgent = new LocalAgent();
            localAgent.agentName = agentName;
            mapLocalAgent.put(agentName, localAgent);
            logger.debug("context created");
            localAgent.jmsContext = TopicContextFactory.getTopicContextFactory().createContext(agentName);

        }
        
        for (Bus bus : buses){
            int index = bus.ordinal();
            
            switch (index){
                case 0 :
                    localAgent.consumers[0]=TopicContextFactory.getTopicContextFactory().getLogSubscriber(localAgent.jmsContext, agentName, null);
                    try {
                        localAgent.receivers[0] = new BusReceiver(agentName, bus, localAgent.consumers[0]);
                    } catch (JMSException ex) {
                        logger.error(JMSBusMessagingLayer.class.getName());
                    }
                    break;
                case 1 :
                    localAgent.consumers[1]=TopicContextFactory.getTopicContextFactory().getStatusSubscriber(localAgent.jmsContext, agentName, null);
                    try {
                        localAgent.receivers[1] = new BusReceiver(agentName, bus, localAgent.consumers[1]);
                    } catch (JMSException ex) {
                        logger.error(JMSBusMessagingLayer.class.getName());
                    }
                    break;
                case 2 :
                    localAgent.consumers[2]=TopicContextFactory.getTopicContextFactory().getCommandSubscriber(localAgent.jmsContext, agentName, "destination=\'"+agentName+"\'");
                    try {
                        localAgent.receivers[2] = new BusReceiver(agentName, bus, localAgent.consumers[2]);
                    } catch (JMSException ex) {
                        logger.error(JMSBusMessagingLayer.class.getName());
                    }
                    break;
            }
        }
    }
}
