package org.lsst.ccs.bus.jms;

import org.lsst.ccs.utilities.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Properties;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

/**
 *
 * @author emarin
 */
public class TopicContextFactory {
    static protected TopicContextFactory instance = null;
    
    public static synchronized TopicContextFactory getTopicContextFactory() {
        if (instance == null) {
            instance = new TopicContextFactory();
        }
        return instance;
    }
    
    static Logger log = Logger.getLogger("org.lsst.ccs.bus.jms.TopicSessionFactory");
    
    Context context;
    
    ConnectionFactory tcf;
    
    //JMX
//    private AdminConnectionFactory acf = new AdminConnectionFactory();
//    private JMXConnector jmxc;
//    private MBeanServerConnection mbsc;
    
    Topic statusTopic;
    Topic commandTopic;
    Topic logTopic;
    
    public void reset() {
        context = null;
        tcf = null;
        commandTopic = null;
        logTopic = null;
        statusTopic = null;
    }
    
    public synchronized void getTopicContext() {
        try {
//            if (jmxc == null){
//                jmxc = acf.createConnection();
//                mbsc = jmxc.getMBeanServerConnection();
//            }
            if (context == null) {
                Properties props = BootstrapResourceUtils.getBootstrapProperties("jndi");
                context = new InitialContext(props);
            }
            if (tcf == null) {
                tcf = (ConnectionFactory) context.lookup("ConnectionFactory");
            }
             if (commandTopic == null) {
                log.info("lookup topic/control/command");
                commandTopic = (Topic) context.lookup("topic/control/command");
                
            }
            if (statusTopic == null) {
                log.info("lookup topic/control/status");
                statusTopic = (Topic) context.lookup("topic/control/status");
                
            }
            if (logTopic == null) {
                log.info("lookup topic/control/log");
                logTopic = (Topic) context.lookup("topic/control/log");
                
            }
            // Destroy all existing connections (just in case)
           
            
            
        } catch (NamingException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
//        } catch (JMException ex) {
//            log.error(TopicContextFactory.class.getName());
//            throw new RuntimeException(ex);
//        } catch (IOException ex) {
//            log.error(TopicContextFactory.class.getName());
//            throw new RuntimeException(ex);
        } 
    }
    
    public synchronized JMSContext createContext(String agentName){
        if (tcf == null){
            getTopicContext();
        }
        JMSContext jmsContext = tcf.createContext();
            if (agentName != null){
                jmsContext.setClientID(agentName);
            }
            return jmsContext;
    }
    
    
    public synchronized Topic getCommandTopic() {
        if (commandTopic == null) {
            getTopicContext();
        }
        return commandTopic;
    }
    
    public synchronized Topic getStatusTopic() {
        if (statusTopic == null) {
            getTopicContext();
        }
        return statusTopic;
    }
    
    public synchronized Topic getLogTopic() {
        if (logTopic == null) {
            getTopicContext();
        }
        return logTopic;
    }
    
    public synchronized Topic getTopic(String topic){
        switch (topic){
            case "LOG":
                return getLogTopic();
            case "STATUS":
                return getStatusTopic();
            case "COMMAND":
                return getCommandTopic();
            default :
                return null;
        }
    }
    
    public JMSProducer getProducer(JMSContext ctxt) {
        return ctxt.createProducer();
    }

    public JMSConsumer getCommandSubscriber(JMSContext ctxt, String agentName,
            String messageSelector) {
        return ctxt.createConsumer(commandTopic, messageSelector, false);
    }
    
    public JMSConsumer getStatusSubscriber(JMSContext ctxt,String agentName,
            String messageSelector) {
        return ctxt.createConsumer(statusTopic, messageSelector, false);
    }
    
    public JMSConsumer getLogSubscriber(JMSContext ctxt, String agentName, String messageSelector) {
        return ctxt.createConsumer(logTopic, messageSelector, false);
    }
    
    public JMSProducer getCommandReplyPublisher(JMSContext ctxt,
            Destination dest) {
        return ctxt.createProducer();
    }
    
//    public MBeanServerConnection getMBeanServerConnection(){
//        if (mbsc == null){
//            getTopicContext();
//        }
//        return mbsc;
//    }
}
