/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jms;

import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class TopicContextFactory {
    protected static TopicContextFactory instance = null;
    static Logger log = Logger.getLogger((String)"org.lsst.ccs.bus.jms.TopicSessionFactory");
    Context context;
    ConnectionFactory tcf;
    Topic statusTopic;
    Topic commandTopic;
    Topic logTopic;

    public static synchronized TopicContextFactory getTopicContextFactory() {
        if (instance == null) {
            instance = new TopicContextFactory();
        }
        return instance;
    }

    public void reset() {
        this.context = null;
        this.tcf = null;
        this.commandTopic = null;
        this.logTopic = null;
        this.statusTopic = null;
    }

    public synchronized void getTopicContext() {
        try {
            if (this.context == null) {
                Properties props = BootstrapResourceUtils.getBootstrapProperties((String)"jndi");
                this.context = new InitialContext(props);
            }
            if (this.tcf == null) {
                this.tcf = (ConnectionFactory)this.context.lookup("ConnectionFactory");
            }
            if (this.commandTopic == null) {
                log.info((Object)"lookup topic/control/command", new String[0]);
                this.commandTopic = (Topic)this.context.lookup("topic/control/command");
            }
            if (this.statusTopic == null) {
                log.info((Object)"lookup topic/control/status", new String[0]);
                this.statusTopic = (Topic)this.context.lookup("topic/control/status");
            }
            if (this.logTopic == null) {
                log.info((Object)"lookup topic/control/log", new String[0]);
                this.logTopic = (Topic)this.context.lookup("topic/control/log");
            }
        }
        catch (NamingException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
    }

    public synchronized JMSContext createContext(String agentName) {
        if (this.tcf == null) {
            this.getTopicContext();
        }
        JMSContext jmsContext = this.tcf.createContext();
        if (agentName != null) {
            jmsContext.setClientID(agentName);
        }
        return jmsContext;
    }

    public synchronized Topic getCommandTopic() {
        if (this.commandTopic == null) {
            this.getTopicContext();
        }
        return this.commandTopic;
    }

    public synchronized Topic getStatusTopic() {
        if (this.statusTopic == null) {
            this.getTopicContext();
        }
        return this.statusTopic;
    }

    public synchronized Topic getLogTopic() {
        if (this.logTopic == null) {
            this.getTopicContext();
        }
        return this.logTopic;
    }

    public synchronized Topic getTopic(String topic) {
        switch (topic) {
            case "LOG": {
                return this.getLogTopic();
            }
            case "STATUS": {
                return this.getStatusTopic();
            }
            case "COMMAND": {
                return this.getCommandTopic();
            }
        }
        return null;
    }

    public JMSProducer getProducer(JMSContext ctxt) {
        return ctxt.createProducer();
    }

    public JMSConsumer getCommandSubscriber(JMSContext ctxt, String agentName, String messageSelector) {
        return ctxt.createConsumer((Destination)this.commandTopic, messageSelector, false);
    }

    public JMSConsumer getStatusSubscriber(JMSContext ctxt, String agentName, String messageSelector) {
        return ctxt.createConsumer((Destination)this.statusTopic, messageSelector, false);
    }

    public JMSConsumer getLogSubscriber(JMSContext ctxt, String agentName, String messageSelector) {
        return ctxt.createConsumer((Destination)this.logTopic, messageSelector, false);
    }

    public JMSProducer getCommandReplyPublisher(JMSContext ctxt, Destination dest) {
        return ctxt.createProducer();
    }
}

