/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jms;

import com.sun.messaging.jms.management.server.ConnectionNotification;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.BusMessageForwarder;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.BusPayload;
import org.lsst.ccs.bus.jms.TopicContextFactory;

public class JMSBusMessagingLayer
implements BusMessagingLayer {
    private static org.lsst.ccs.utilities.logging.Logger logger = org.lsst.ccs.utilities.logging.Logger.getLogger((String)"org.lsst.ccs.bus.jms.JMSBusMessagingLayer");
    BusMembershipListener[] membershipListeners = new BusMembershipListener[Bus.values().length];
    private Map<String, LocalAgent> mapLocalAgent = new ConcurrentHashMap<String, LocalAgent>();
    private MembershipNotificationListener connectionListener = new MembershipNotificationListener();
    private Map<String, String> mapGlobalConnections = new ConcurrentHashMap<String, String>();

    public void close() throws IOException {
        for (String key : this.mapLocalAgent.keySet()) {
            logger.info((Object)("******** removing " + key), new String[0]);
            LocalAgent localAgent = this.mapLocalAgent.get(key);
            JMSConsumer[] jMSConsumerArray = localAgent.consumers;
            int n = localAgent.consumers.length;
            int n2 = 0;
            while (n2 < n) {
                JMSConsumer mc = jMSConsumerArray[n2];
                if (mc != null) {
                    mc.close();
                }
                ++n2;
            }
        }
    }

    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = this.mapLocalAgent.get((Object)agentName).receivers[bus.ordinal()];
            if (receiver == null) {
                throw new IllegalArgumentException(" agent " + agentName + "not registered on bus " + bus);
            }
            receiver.addForwarder(forwarder);
            ++n2;
        }
    }

    public void closeFor(String agentName, Bus ... buses) {
        LocalAgent localAgent;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgent = this.mapLocalAgent.get(agentName)) != null) {
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus b = busArray[n2];
                int index = b.ordinal();
                localAgent.consumers[index].close();
                localAgent.jmsContext.unsubscribe(agentName);
                ++n2;
            }
        }
    }

    public void setMembershipListener(BusMembershipListener listener, Bus ... buses) {
        if (buses == null) {
            buses = Bus.values();
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            this.membershipListeners[bus.ordinal()] = listener;
            ++n2;
        }
    }

    public List<String> getConnectedNames(Bus bus) {
        ArrayList<String> res = new ArrayList<String>();
        MBeanServerConnection mbsc = TopicContextFactory.getTopicContextFactory().getMBeanServerConnection();
        try {
            ObjectName obj = new ObjectName("com.sun.messaging.jms.server:type=ConnectionManager,subtype=Monitor");
            ObjectName[] listConnections = (ObjectName[])mbsc.invoke(obj, "getConnections", null, null);
            HashMap<String, String> mapConnectionsIDs = new HashMap<String, String>();
            ObjectName[] objectNameArray = listConnections;
            int n = listConnections.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectName c = objectNameArray[n2];
                String connID = (String)mbsc.getAttribute(c, "ConnectionID");
                String clientID = (String)mbsc.getAttribute(c, "ClientID");
                mapConnectionsIDs.put(connID, clientID);
                ++n2;
            }
            ObjectName objectName = MQObjectName.createDestinationMonitor((String)"t", (String)("topic_control_" + bus.toString().toLowerCase()));
            String[] list = (String[])mbsc.invoke(objectName, "getConsumerIDs", null, null);
            ArrayList<String> topicConsumerIDs = new ArrayList<String>();
            String[] stringArray = list;
            int n3 = list.length;
            int n4 = 0;
            while (n4 < n3) {
                String list1 = stringArray[n4];
                ObjectName objName = new ObjectName("com.sun.messaging.jms.server:type=ConsumerManager,subtype=Monitor");
                Object[] opParams = new Object[]{list1};
                String[] opSig = new String[]{String.class.getName()};
                CompositeData agentInfo = (CompositeData)mbsc.invoke(objName, "getConsumerInfoByID", opParams, opSig);
                topicConsumerIDs.add((String)agentInfo.get("ConnectionID"));
                ++n4;
            }
            for (String s : topicConsumerIDs) {
                if (!mapConnectionsIDs.containsKey(s)) continue;
                res.add((String)mapConnectionsIDs.get(s));
            }
            return res;
        }
        catch (IOException | NullPointerException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException exception) {
            logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
            return res;
        }
    }

    public <T extends BusPayload> void sendMessage(String senderAgent, Bus<T> bus, T message, String ... destinations) throws IOException {
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        bus.ordinal();
        JMSContext ctxt = this.mapLocalAgent.get((Object)senderAgent).jmsContext;
        JMSProducer send = ctxt.createProducer();
        if (bus == Bus.COMMAND && destinations.length != 0) {
            String[] stringArray = destinations;
            int n = destinations.length;
            int n2 = 0;
            while (n2 < n) {
                String dest = stringArray[n2];
                this.sendMessageToDestination(ctxt, message, dest, send, bus);
                ++n2;
            }
        } else {
            this.sendMessageToDestination(ctxt, message, "", send, bus);
        }
    }

    public <T extends BusPayload> void sendMessageToDestination(JMSContext ctxt, T message, String dest, JMSProducer send, Bus<T> bus) {
        ObjectMessage m;
        try {
            m = ctxt.createObjectMessage();
            m.setObject(message);
            if (!dest.isEmpty()) {
                m.setStringProperty("destination", dest);
            }
        }
        catch (JMSException e) {
            logger.error((Object)e, new String[0]);
            throw new RuntimeException(e);
        }
        try {
            m.setJMSMessageID("0");
            m.setJMSPriority(4);
            m.setJMSReplyTo((Destination)TopicContextFactory.getTopicContextFactory().getCommandTopic());
            m.setJMSTimestamp(System.currentTimeMillis());
            String busName = bus.toString();
            send.send((Destination)TopicContextFactory.getTopicContextFactory().getTopic(busName), (Message)m);
        }
        catch (JMSException e) {
            logger.error((Object)"Error sending message", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        LocalAgent localAgent;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgent = this.mapLocalAgent.get(agentName)) == null) {
            return;
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = localAgent.receivers[bus.ordinal()];
            if (receiver != null) {
                receiver.removeForwarder(forwarder);
            }
            ++n2;
        }
    }

    public void register(String agentName, Bus ... buses) throws IOException {
        LocalAgent localAgent;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        StringBuilder allBuses = new StringBuilder();
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            allBuses.append(bus.toString()).append(" ");
            ++n2;
        }
        logger.info((Object)("### Registering " + agentName + " for buses " + allBuses), new String[0]);
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if (this.mapLocalAgent.isEmpty()) {
            this.updateConnectionsMap();
        }
        if ((localAgent = this.mapLocalAgent.get(agentName)) == null) {
            localAgent = new LocalAgent();
            localAgent.agentName = agentName;
            this.mapLocalAgent.put(agentName, localAgent);
            logger.debug((Object)"context created", new String[0]);
            localAgent.jmsContext = TopicContextFactory.getTopicContextFactory().createContext(agentName);
        }
        Bus[] busArray2 = buses;
        int n3 = buses.length;
        n = 0;
        while (n < n3) {
            Bus bus = busArray2[n];
            int index = bus.ordinal();
            switch (index) {
                case 0: {
                    localAgent.consumers[0] = TopicContextFactory.getTopicContextFactory().getLogSubscriber(localAgent.jmsContext, agentName, null);
                    try {
                        localAgent.receivers[0] = new BusReceiver(agentName, bus, localAgent.consumers[0]);
                    }
                    catch (JMSException jMSException) {
                        logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
                    }
                    break;
                }
                case 1: {
                    localAgent.consumers[1] = TopicContextFactory.getTopicContextFactory().getStatusSubscriber(localAgent.jmsContext, agentName, null);
                    try {
                        localAgent.receivers[1] = new BusReceiver(agentName, bus, localAgent.consumers[1]);
                    }
                    catch (JMSException jMSException) {
                        logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
                    }
                    break;
                }
                case 2: {
                    localAgent.consumers[2] = TopicContextFactory.getTopicContextFactory().getCommandSubscriber(localAgent.jmsContext, agentName, "destination='" + agentName + "'");
                    try {
                        localAgent.receivers[2] = new BusReceiver(agentName, bus, localAgent.consumers[2]);
                        break;
                    }
                    catch (JMSException jMSException) {
                        logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
                    }
                }
            }
            BusMembershipListener listener = this.membershipListeners[index];
            if (listener != null) {
                listener.connecting(agentName, "");
            }
            ++n;
        }
    }

    private synchronized void addToConnectionMap(String connectionID) {
        MBeanServerConnection mbsc = TopicContextFactory.getTopicContextFactory().getMBeanServerConnection();
        try {
            String clientID = null;
            while (clientID == null) {
                ObjectName obj = new ObjectName("com.sun.messaging.jms.server:type=ConnectionManager,subtype=Monitor");
                ObjectName[] listConnections = (ObjectName[])mbsc.invoke(obj, "getConnections", null, null);
                HashMap<String, String> mapConnectionsIDs = new HashMap<String, String>();
                ObjectName[] objectNameArray = listConnections;
                int n = listConnections.length;
                int n2 = 0;
                while (n2 < n) {
                    ObjectName c = objectNameArray[n2];
                    String connID = (String)mbsc.getAttribute(c, "ConnectionID");
                    String cliID = (String)mbsc.getAttribute(c, "ClientID");
                    mapConnectionsIDs.put(connID, cliID);
                    ++n2;
                }
                clientID = (String)mapConnectionsIDs.get(connectionID);
            }
            this.mapGlobalConnections.put(connectionID, clientID);
            logger.debug((Object)("mapGlobalConnections " + this.mapGlobalConnections), new String[0]);
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException exception) {
            logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
        }
    }

    private synchronized void removeFromConnectionMap(String connID) {
        this.mapGlobalConnections.remove(connID);
        logger.debug((Object)("mapGlobalConnections " + this.mapGlobalConnections), new String[0]);
    }

    private synchronized void updateConnectionsMap() {
        MBeanServerConnection mbsc = TopicContextFactory.getTopicContextFactory().getMBeanServerConnection();
        try {
            ObjectName obj = new ObjectName("com.sun.messaging.jms.server:type=ConnectionManager,subtype=Monitor");
            ObjectName[] listConnections = (ObjectName[])mbsc.invoke(obj, "getConnections", null, null);
            HashMap<String, String> mapConnectionsIDs = new HashMap<String, String>();
            if (listConnections != null) {
                ObjectName[] objectNameArray = listConnections;
                int n = listConnections.length;
                int n2 = 0;
                while (n2 < n) {
                    ObjectName c = objectNameArray[n2];
                    String connID = (String)mbsc.getAttribute(c, "ConnectionID");
                    String clientID = (String)mbsc.getAttribute(c, "ClientID");
                    mapConnectionsIDs.put(connID, clientID);
                    ++n2;
                }
                this.mapGlobalConnections.clear();
                for (String key : mapConnectionsIDs.keySet()) {
                    String val = (String)mapConnectionsIDs.get(key);
                    if (val != null) {
                        this.mapGlobalConnections.put(key, val);
                        continue;
                    }
                    logger.trace((Object)("no clientID found for key " + key), new String[0]);
                }
            }
            logger.trace((Object)("globalConnections : " + this.mapGlobalConnections), new String[0]);
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException exception) {
            logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
        }
    }

    class BusReceiver
    implements MessageListener {
        Bus bus;
        JMSConsumer curConsumer;
        CopyOnWriteArrayList<BusMessageForwarder> listForwarders;
        String agentName;

        public BusReceiver(String agentName, Bus bus, JMSConsumer curConsumer) throws JMSException {
            this.agentName = agentName;
            this.bus = bus;
            this.curConsumer = curConsumer;
            curConsumer.setMessageListener((MessageListener)this);
        }

        public void addForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                this.listForwarders = new CopyOnWriteArrayList();
            }
            this.listForwarders.add(forwarder);
        }

        public void removeForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                return;
            }
            this.listForwarders.remove(forwarder);
        }

        public void onMessage(Message message) {
            BusMessage busMessInit = null;
            if (this.listForwarders == null) {
                return;
            }
            if (this.listForwarders.isEmpty()) {
                return;
            }
            try {
                busMessInit = (BusMessage)((ObjectMessage)message).getObject();
            }
            catch (JMSException jMSException) {
                logger.error((Object)JMSBusMessagingLayer.class.getName(), new String[0]);
            }
            BusMessage busMess = busMessInit;
            if (busMess.getOrigin().equals(this.agentName)) {
                logger.trace((Object)"message received by same agent than sender", new String[0]);
                return;
            }
            for (BusMessageForwarder forwarder : this.listForwarders) {
                forwarder.update(busMess);
            }
        }
    }

    class LocalAgent {
        int id;
        String agentName;
        JMSContext jmsContext;
        JMSConsumer[] consumers = new JMSConsumer[Bus.values().length];
        BusReceiver[] receivers = new BusReceiver[Bus.values().length];

        LocalAgent() {
        }
    }

    public class MembershipNotificationListener
    implements NotificationListener {
        private ObjectName connectionManagerMonitor;

        public MembershipNotificationListener() {
            try {
                MBeanServerConnection mbsc = TopicContextFactory.getTopicContextFactory().getMBeanServerConnection();
                this.connectionManagerMonitor = new ObjectName("com.sun.messaging.jms.server:type=ConnectionManager,subtype=Monitor");
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("mq.connection.close");
                filter.enableType("mq.connection.open");
                mbsc.addNotificationListener(this.connectionManagerMonitor, this, (NotificationFilter)filter, null);
            }
            catch (IOException | JMException ex) {
                Logger.getLogger(JMSBusMessagingLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            ConnectionNotification connNotif = (ConnectionNotification)notification;
            String connectionID = connNotif.getConnectionID();
            switch (connNotif.getType()) {
                case "mq.connection.close": {
                    String clientID = (String)JMSBusMessagingLayer.this.mapGlobalConnections.get(connectionID);
                    if (clientID == null) {
                        logger.debug((Object)("disconnection suspicion on " + connectionID), new String[0]);
                    } else {
                        logger.warn((Object)("disconnection suspicion on " + clientID), new String[0]);
                    }
                    JMSBusMessagingLayer.this.removeFromConnectionMap(connectionID);
                    break;
                }
                case "mq.connection.open": {
                    logger.debug((Object)("new connection : " + connectionID), new String[0]);
                    JMSBusMessagingLayer.this.addToConnectionMap(connectionID);
                    break;
                }
                default: {
                    logger.error((Object)"type not recognized", new String[0]);
                }
            }
        }
    }
}

