package org.lsst.ccs.bus.jms;

//import org.apache.log4j.Logger;
import org.lsst.ccs.bus.*;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import com.sun.messaging.jms.management.server.ConnectionAttributes;
import com.sun.messaging.jms.management.server.ConnectionNotification;
import com.sun.messaging.jms.management.server.ConnectionOperations;
import com.sun.messaging.jms.management.server.ConsumerInfo;
import com.sun.messaging.jms.management.server.ConsumerOperations;
import com.sun.messaging.jms.management.server.DestinationOperations;
import com.sun.messaging.jms.management.server.DestinationType;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.ArrayList;
import javax.jms.JMSContext;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import static org.lsst.ccs.bus.BusMessagingLayer.ANONYMOUS_AGENT;

/**
 */
public class JMSBusMessagingLayer implements BusMessagingLayer {
     private static org.lsst.ccs.utilities.logging.Logger logger = org.lsst.ccs.utilities.logging.Logger.getLogger("org.lsst.ccs.bus.jms.JMSBusMessagingLayer");
    
    BusMembershipListener[] membershipListeners = new BusMembershipListener[Bus.values().length];
    
    private Map<String, LocalAgent> mapLocalAgent = new ConcurrentHashMap<>();
    private MembershipNotificationListener connectionListener = new MembershipNotificationListener();
    
    private Map<String, String> mapGlobalConnections = new ConcurrentHashMap<>();
    
    class LocalAgent{
        int id; // ID for JMS Communication
        String agentName;
        JMSContext jmsContext;
        JMSConsumer[] consumers = new JMSConsumer[Bus.values().length];
        BusReceiver[] receivers = new BusReceiver[Bus.values().length];
    }
    
    class  BusReceiver implements MessageListener{
        
        Bus bus;
        //todo: duplicate information
        JMSConsumer curConsumer;
        //ParallelCommandDispatcher dispatcher;
        CopyOnWriteArrayList<BusMessageForwarder> listForwarders;
        //todo: again a duplicate!
        String agentName;
        
        public BusReceiver(String agentName, Bus bus, JMSConsumer curConsumer) throws JMSException {
            this.agentName = agentName;
            this.bus = bus;
            this.curConsumer = curConsumer;
            curConsumer.setMessageListener(this);
        }
        
        public void addForwarder(BusMessageForwarder forwarder) {
            //TODO: reinstall Parallel ?
            /*
            if (dispatcher == null) {
            dispatcher = new ParallelCommandDispatcher();
            }
            dispatcher.addExecutant(forwarder);
            */
            if (listForwarders == null) {
                listForwarders = new CopyOnWriteArrayList<BusMessageForwarder>();
            }
            listForwarders.add(forwarder);
        }
        
        public void removeForwarder(BusMessageForwarder forwarder) {
            /*
            if (dispatcher == null) return;
            dispatcher.removeExecutant(forwarder);
            */
            if (listForwarders == null) {
                return;
            }
            listForwarders.remove(forwarder);
        }
        
        @Override
        public void onMessage(Message message) {
            
            BusMessage busMessInit=null;
            try {
                if (listForwarders == null) {
                    return;
                }
                if (listForwarders.isEmpty()) {
                    return;
                }
//                if (bus == Bus.COMMAND && message.propertyExists("destination")){
//                    // split the string
//                    String[] array = message.getStringProperty("destination").split(" ");
//
//
//                }
                try {
                    busMessInit = (BusMessage) ((ObjectMessage)message).getObject();
                } catch (JMSException ex) {
                    logger.error(JMSBusMessagingLayer.class.getName());
                }
            } catch (final RuntimeException exc) {
                throw exc;
                //TODO: create a generic Message for reporting errors
                /* busMessInit = new BusMessage() {
                @Override
                public String getMessageType() {
                return "error" + exc;
                }
                } ;
                */
            }
            final BusMessage busMess = busMessInit;
            if (busMess.getOrigin().equals(agentName)) {
                logger.trace("message received by same agent than sender");
                return;
            }
            // TODO : reinstall parallel
            for (BusMessageForwarder forwarder : listForwarders) {
                forwarder.update(busMess);
            }
        }
    }
    
    
    
    public class MembershipNotificationListener implements NotificationListener{
        private ObjectName connectionManagerMonitor;
        
        public MembershipNotificationListener(){
            try {
                MBeanServerConnection mbsc = TopicContextFactory.getTopicContextFactory().getMBeanServerConnection();
                connectionManagerMonitor = new ObjectName(MQObjectName.CONNECTION_MANAGER_MONITOR_MBEAN_NAME);
                
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType(ConnectionNotification.CONNECTION_CLOSE);
                filter.enableType(ConnectionNotification.CONNECTION_OPEN);
                
                mbsc.addNotificationListener(connectionManagerMonitor, this, filter, null);
                
            } catch (JMException | IOException ex) {
                Logger.getLogger(JMSBusMessagingLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
            
        }
        
        @Override
        public void handleNotification(Notification notification, Object handback) {
            
            ConnectionNotification connNotif = (ConnectionNotification) notification;
            
            String connectionID = connNotif.getConnectionID();
            
            switch (connNotif.getType()) {
                case ConnectionNotification.CONNECTION_CLOSE:
                    String clientID = mapGlobalConnections.get(connectionID);
                    if (clientID==null){
                        // TODO : some unexpected connections are created and do not correspond to any subsystem
                        logger.debug("disconnection suspicion on " + connectionID);
                    }
                    else{
                        logger.warn("disconnection suspicion on " + clientID);
                    }   
                    removeFromConnectionMap(connectionID);
                    break;
                case ConnectionNotification.CONNECTION_OPEN:
                    logger.debug("new connection : " + connectionID);
                    addToConnectionMap(connectionID);
                    break;
                default:
                    logger.error("type not recognized");
                    break;
            }
        }
    }
    
    // Close the entire local connections
    @Override
    public void close() throws IOException {
        Iterator<String> itKeys = mapLocalAgent.keySet().iterator();
        while (itKeys.hasNext()) {
            String key = itKeys.next();
            logger.info("******** removing " + key);
            LocalAgent localAgent = mapLocalAgent.get(key);
            BusMembershipListener listener;
            for (JMSConsumer mc : localAgent.consumers) {
                if (mc != null) {
                    mc.close();
                }
            }
            //updateConnectionsMap();
            // TODO : Do we need to destroy the connection itself ?
        }
    }
    
    @Override
    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus... buses) {

        if (agentName == null || "".equals(agentName)) {
            agentName = ANONYMOUS_AGENT;
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        
        for (Bus bus : buses){
            BusReceiver receiver  = mapLocalAgent.get(agentName).receivers[bus.ordinal()];
            if (receiver == null) {
                throw new IllegalArgumentException(" agent " + agentName + "not registered on bus " + bus);
            }
            receiver.addForwarder(forwarder);
        }
    }
    
    @Override
    public void closeFor(String agentName, Bus... buses) {
        if (agentName == null || "".equals(agentName)) {
            agentName = ANONYMOUS_AGENT;
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        LocalAgent localAgent = mapLocalAgent.get(agentName);
        if (localAgent != null){
            for (Bus b : buses){
                int index = b.ordinal();
                localAgent.consumers[index].close();
                localAgent.jmsContext.unsubscribe(agentName);
            }
        }
       // updateConnectionsMap();
    }
    
    @Override
    public void setMembershipListener(BusMembershipListener listener, Bus... buses) {
        if (buses == null){
            buses = Bus.values();
        }
        for (Bus bus : buses) {
            
            membershipListeners[bus.ordinal()] = listener;
        }
    }
    
    @Override
    public List<String> getConnectedNames(Bus bus) {
        List<String> res = new ArrayList<>();
        
        MBeanServerConnection mbsc = TopicContextFactory.getTopicContextFactory().getMBeanServerConnection();
        
        try {
            // Get the list of connections
            ObjectName obj = new ObjectName(MQObjectName.CONNECTION_MANAGER_MONITOR_MBEAN_NAME);
            ObjectName[] listConnections = (ObjectName[])mbsc.invoke(obj, ConnectionOperations.GET_CONNECTIONS, null, null);
            // create a map <connectionID,clientID>
            Map<String, String> mapConnectionsIDs = new HashMap<String,String>();
            for (ObjectName c : listConnections){
                String connID = (String)mbsc.getAttribute(c, ConnectionAttributes.CONNECTION_ID);
                String clientID = (String)mbsc.getAttribute(c, ConnectionAttributes.CLIENT_ID);
                mapConnectionsIDs.put(connID, clientID);
            }
            
            // get the list of consumers connected to 'bus'
            ObjectName objectName = MQObjectName.createDestinationMonitor(DestinationType.TOPIC, "topic_control_"+bus.toString().toLowerCase());
            String[] list = (String[]) mbsc.invoke(objectName, DestinationOperations.GET_CONSUMER_IDS, null, null);
            
            // from this list, create a list of connectionIDs
            
            List<String> topicConsumerIDs = new ArrayList<>();
            for (String list1 : list) {
                ObjectName objName = new ObjectName(MQObjectName.CONSUMER_MANAGER_MONITOR_MBEAN_NAME);
                // Parameters for get_consumer_info_by_id
                Object opParams[]={list1};
                // List of parameters types
                String opSig[]={String.class.getName()};
                CompositeData agentInfo = (CompositeData) mbsc.invoke(objName,ConsumerOperations.GET_CONSUMER_INFO_BY_ID, opParams, opSig);
                topicConsumerIDs.add((String)agentInfo.get(ConsumerInfo.CONNECTION_ID));
            }
            
            // From the list of connections, create a list of connections that matches the connectionIDs
            for (String s : topicConsumerIDs){
                if (mapConnectionsIDs.containsKey(s)){
                    res.add(mapConnectionsIDs.get(s));
                }
            }
            
            return res;
            
        } catch (MalformedObjectNameException | NullPointerException | InstanceNotFoundException | MBeanException | ReflectionException | IOException | AttributeNotFoundException ex) {
            logger.error(JMSBusMessagingLayer.class.getName());
        }
        return res;
    }
    
    @Override
    public <T extends BusPayload> void sendMessage(String senderAgent, Bus<T> bus, T message, String... destinations) throws IOException {
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        int index = bus.ordinal();
        
        JMSContext ctxt = mapLocalAgent.get(senderAgent).jmsContext;
        JMSProducer send = ctxt.createProducer();
        
        
        if (bus == Bus.COMMAND && destinations.length != 0){
            for (String dest : destinations){
                sendMessageToDestination(ctxt, message, dest, send, bus);
            }
        }
        else {
            sendMessageToDestination(ctxt, message, "", send, bus);
        }
    }
    
    public <T extends BusPayload> void sendMessageToDestination(JMSContext ctxt, T message, String dest, JMSProducer send, Bus<T> bus){
        ObjectMessage m;
        try {
            m = ctxt.createObjectMessage();
            m.setObject(message);
            //m.setJMSType(message.getMessageType());
            if (!dest.isEmpty()){
                m.setStringProperty("destination", dest);
            }
            //m.setJMSPriority(convertToJMSPriority(message.getPriorityLevel()));
            //if (message.getCorrelId() != null) {
            //    m.setJMSCorrelationID(cmd.getCorrelId());
            //}
            
        } catch (JMSException e) {
            logger.error(e);
            throw new RuntimeException(e);
        }
        try {
            // if (m.getJMSCorrelationID() == null) {
            //     m.setJMSCorrelationID(localCorrelID.get());
            // }
            m.setJMSMessageID("0"); /* TODO handle messageid */
            m.setJMSPriority(4); // 0-4 normal, 4-9 expedited
            
            // uncomment to send replies on the command topic
            
            m.setJMSReplyTo(TopicContextFactory.getTopicContextFactory().getCommandTopic());
            
            m.setJMSTimestamp(System.currentTimeMillis());
            String busName = bus.toString();
            
            send.send(TopicContextFactory.getTopicContextFactory().getTopic(busName), m);
            //   send.
        } catch (JMSException e) {
            logger.error("Error sending message", e);
            throw new RuntimeException(e);
        }
    }
    
    @Override
    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus... buses) {
        if (agentName == null || "".equals(agentName)) {
            agentName = ANONYMOUS_AGENT;
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        LocalAgent localAgent = mapLocalAgent.get(agentName);
        if (localAgent == null) {
            return;
        }
        for (Bus bus : buses) {
            BusReceiver receiver = localAgent.receivers[bus.ordinal()];
            if (receiver == null) {
                continue;
            }
            receiver.removeForwarder(forwarder);
        }
    }
    
    @Override
    public void register(String agentName, Bus... buses) throws IOException {
        
        if (agentName == null || "".equals(agentName)) {
            agentName = ANONYMOUS_AGENT;
        }
        
        StringBuilder allBuses = new StringBuilder();
        for (Bus bus : buses) {
            allBuses.append(bus.toString()).append(" ");
        }
        logger.info("### Registering " + agentName + " for buses " + allBuses);
        
        
        if (buses.length == 0){
            buses = Bus.values();
        }
        
        // If agentName is the first to register, update mapGlobalConnections
        if (mapLocalAgent.isEmpty()){
            updateConnectionsMap();
        }
        // Is this agent known to the map ?
        LocalAgent localAgent = mapLocalAgent.get(agentName);
        if (localAgent == null){
            localAgent = new LocalAgent();
            localAgent.agentName = agentName;
            mapLocalAgent.put(agentName, localAgent);
            logger.debug("context created");
            localAgent.jmsContext = TopicContextFactory.getTopicContextFactory().createContext(agentName);

        }
        
        for (Bus bus : buses){
            int index = bus.ordinal();
            
            switch (index){
                case 0 :
                    localAgent.consumers[0]=TopicContextFactory.getTopicContextFactory().getLogSubscriber(localAgent.jmsContext, agentName, null);
                    try {
                        localAgent.receivers[0] = new BusReceiver(agentName, bus, localAgent.consumers[0]);
                    } catch (JMSException ex) {
                        logger.error(JMSBusMessagingLayer.class.getName());
                    }
                    break;
                case 1 :
                    localAgent.consumers[1]=TopicContextFactory.getTopicContextFactory().getStatusSubscriber(localAgent.jmsContext, agentName, null);
                    try {
                        localAgent.receivers[1] = new BusReceiver(agentName, bus, localAgent.consumers[1]);
                    } catch (JMSException ex) {
                        logger.error(JMSBusMessagingLayer.class.getName());
                    }
                    break;
                case 2 :
                    localAgent.consumers[2]=TopicContextFactory.getTopicContextFactory().getCommandSubscriber(localAgent.jmsContext, agentName, "destination=\'"+agentName+"\'");
                    try {
                        localAgent.receivers[2] = new BusReceiver(agentName, bus, localAgent.consumers[2]);
                    } catch (JMSException ex) {
                        logger.error(JMSBusMessagingLayer.class.getName());
                    }
                    break;
            }
            BusMembershipListener listener = membershipListeners[index];
            if (listener != null){
                listener.connecting(agentName, "");
            }
        }
    }
    
    private synchronized void addToConnectionMap(String connectionID){
//        try {
//            Thread.sleep(1000);
//        } catch (InterruptedException ex) {
//            logger.error(JMSBusMessagingLayer.class.getName());
//        }
        MBeanServerConnection mbsc = TopicContextFactory.getTopicContextFactory().getMBeanServerConnection();
        
        try {
            String clientID=null;
            // Todo : notification of opened connection occurs before the connection is named with setClientID
            // we have to wait (spinning) for the connection to be named -> to be modified
            while (clientID == null){
                // Get the list of connections
                ObjectName obj = new ObjectName(MQObjectName.CONNECTION_MANAGER_MONITOR_MBEAN_NAME);
                ObjectName[] listConnections = (ObjectName[])mbsc.invoke(obj, ConnectionOperations.GET_CONNECTIONS, null, null);
                // create a map <connectionID,clientID>
                Map<String, String> mapConnectionsIDs = new HashMap<String,String>();
                
                for (ObjectName c : listConnections){
                    String connID = (String)mbsc.getAttribute(c, ConnectionAttributes.CONNECTION_ID);
                    String cliID = (String)mbsc.getAttribute(c, ConnectionAttributes.CLIENT_ID);
                    mapConnectionsIDs.put(connID, cliID);
                }
                clientID = mapConnectionsIDs.get(connectionID);
            }
            mapGlobalConnections.put(connectionID,clientID);
            logger.debug("mapGlobalConnections " + mapGlobalConnections);
            
        } catch (MalformedObjectNameException | InstanceNotFoundException | MBeanException | ReflectionException | IOException | AttributeNotFoundException ex) {
            logger.error(JMSBusMessagingLayer.class.getName());
        }
    }
    
    private synchronized void removeFromConnectionMap(String connID){
        mapGlobalConnections.remove(connID);
        logger.debug("mapGlobalConnections " + mapGlobalConnections);
    }
    private synchronized void updateConnectionsMap(){
        MBeanServerConnection mbsc = TopicContextFactory.getTopicContextFactory().getMBeanServerConnection();
        
        try {
            // Get the list of connections
            ObjectName obj = new ObjectName(MQObjectName.CONNECTION_MANAGER_MONITOR_MBEAN_NAME);
            ObjectName[] listConnections = (ObjectName[])mbsc.invoke(obj, ConnectionOperations.GET_CONNECTIONS, null, null);
            // create a map <connectionID,clientID>
            Map<String, String> mapConnectionsIDs = new HashMap<String,String>();

            if (listConnections != null){
                for (ObjectName c : listConnections){
                    String connID = (String)mbsc.getAttribute(c, ConnectionAttributes.CONNECTION_ID);
                    String clientID = (String)mbsc.getAttribute(c, ConnectionAttributes.CLIENT_ID);
                    mapConnectionsIDs.put(connID, clientID);
                }
                mapGlobalConnections.clear();
                Iterator<String> itKeys = mapConnectionsIDs.keySet().iterator();
                while (itKeys.hasNext()) {
                    String key = itKeys.next();
                    String val = mapConnectionsIDs.get(key);
                    if (val != null){
                        mapGlobalConnections.put(key,val);
                    }
                    else {
                        logger.trace("no clientID found for key " + key);
                    }
                }
            }
            logger.trace("globalConnections : " + mapGlobalConnections);
        } catch (MalformedObjectNameException | InstanceNotFoundException | MBeanException | ReflectionException | IOException | AttributeNotFoundException ex) {
            logger.error(JMSBusMessagingLayer.class.getName());
        }
    }
}
