package org.lsst.ccs.bus.jms;

// TODO In progress, move from Topic/Queue connections to generic connections
// merge the two session factories then ?

/**
 * JMS Queue session factory
 * 
 * @author aubourg
 *
 */

import org.lsst.ccs.utilities.logging.Logger;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Properties;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;

/**
 * JMS Topic session factory
 * 
 * @author aubourg
 * 
 */

public class TopicSessionFactory {
	static protected TopicSessionFactory instance = null;

	public static synchronized TopicSessionFactory getSessionFactory() {
		if (instance == null) {
			instance = new TopicSessionFactory();
		}
		return instance;
	}

	static Logger log = Logger.getLogger("org.lsst.ccs.bus.jms.TopicSessionFactory");

	Connection conn;

	Context context;

	ConnectionFactory tcf;

	Topic statusTopic;
	Topic commandTopic;
	Topic logTopic;

        public void reset() {
            context = null;
            tcf = null;
            conn = null;
            commandTopic = null;
            logTopic = null;
            statusTopic = null;
                    
        }
        
	public synchronized Session getTopicSession() {
		try {
			if (context == null) {

                            
                            Properties props = BootstrapResourceUtils.getBootstrapProperties("jndi");
                            context = new InitialContext(props);
                            

			}
			if (tcf == null) {
				tcf = (ConnectionFactory) context.lookup("ConnectionFactory");
			}
			if (conn == null) {
				conn = tcf.createConnection();
				conn.start();
			}
			if (commandTopic == null) {
				log.info("lookup topic/control/command");
				commandTopic = (Topic) context.lookup("topic/control/command");
			}
			if (statusTopic == null) {
				log.info("lookup topic/control/status");
				statusTopic = (Topic) context.lookup("topic/control/status");
			}
			if (logTopic == null) {
				log.info("lookup topic/control/log");
				logTopic = (Topic) context.lookup("topic/control/log");
			}


			Session session = conn.createSession(false,
					Session.AUTO_ACKNOWLEDGE);
			return session;
		} catch (NamingException e1) {
			e1.printStackTrace();
			throw new RuntimeException(e1);
		} catch (JMSException e2) {
			e2.printStackTrace();
			throw new RuntimeException(e2);
		}
	}

	public synchronized Topic getCommandTopic() {
		if (commandTopic == null) {
			getTopicSession();
		}
		return commandTopic;
	}

	public synchronized Topic getStatusTopic() {
		if (statusTopic == null) {
			getTopicSession();
		}
		return statusTopic;
	}

	public synchronized Topic getLogTopic() {
		if (logTopic == null) {
			getTopicSession();
		}
		return logTopic;
	}

	public MessageProducer getCommandPublisher(Session sess) {
		try {
			return sess.createProducer(commandTopic);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public MessageProducer getStatusPublisher(Session sess) {
		try {
			return sess.createProducer(statusTopic);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public MessageProducer getLogPublisher(Session sess) {
		try {
			return sess.createProducer(logTopic);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public MessageConsumer getCommandSubscriber(Session sess) {
		try {
			return sess.createConsumer(commandTopic, null, true);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public MessageConsumer getCommandSubscriber(Session sess,
			String messageSelector) {
		try {
			return sess.createConsumer(commandTopic, messageSelector, true);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public MessageConsumer getStatusSubscriber(Session sess) {
		try {
			return sess.createConsumer(statusTopic, null, true);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public MessageConsumer getStatusSubscriber(Session sess,
			String messageSelector) {
		try {
			return sess.createConsumer(statusTopic, messageSelector, true);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public MessageConsumer getLogSubscriber(Session sess, String messageSelector) {
		try {
			return sess.createConsumer(logTopic, messageSelector, true);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public MessageProducer getCommandReplyPublisher(Session sess,
			Destination dest) {
		try {
			return sess.createProducer(dest);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

}
