/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jms;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class TopicSessionFactory {
    protected static TopicSessionFactory instance = null;
    static Logger log = Logger.getLogger((String)"org.lsst.ccs.bus.jms.TopicSessionFactory");
    Connection conn;
    Context context;
    ConnectionFactory tcf;
    Topic statusTopic;
    Topic commandTopic;
    Topic logTopic;

    public static synchronized TopicSessionFactory getSessionFactory() {
        if (instance == null) {
            instance = new TopicSessionFactory();
        }
        return instance;
    }

    public void reset() {
        this.context = null;
        this.tcf = null;
        this.conn = null;
        this.commandTopic = null;
        this.logTopic = null;
        this.statusTopic = null;
    }

    public synchronized Session getTopicSession() {
        try {
            if (this.context == null) {
                Properties props = BootstrapResourceUtils.getBootstrapProperties((String)"jndi");
                this.context = new InitialContext(props);
            }
            if (this.tcf == null) {
                this.tcf = (ConnectionFactory)this.context.lookup("ConnectionFactory");
            }
            if (this.conn == null) {
                this.conn = this.tcf.createConnection();
                this.conn.start();
            }
            if (this.commandTopic == null) {
                log.info((Object)"lookup topic/control/command", new String[0]);
                this.commandTopic = (Topic)this.context.lookup("topic/control/command");
            }
            if (this.statusTopic == null) {
                log.info((Object)"lookup topic/control/status", new String[0]);
                this.statusTopic = (Topic)this.context.lookup("topic/control/status");
            }
            if (this.logTopic == null) {
                log.info((Object)"lookup topic/control/log", new String[0]);
                this.logTopic = (Topic)this.context.lookup("topic/control/log");
            }
            Session session = this.conn.createSession(false, 1);
            return session;
        }
        catch (NamingException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        catch (JMSException e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    public synchronized Topic getCommandTopic() {
        if (this.commandTopic == null) {
            this.getTopicSession();
        }
        return this.commandTopic;
    }

    public synchronized Topic getStatusTopic() {
        if (this.statusTopic == null) {
            this.getTopicSession();
        }
        return this.statusTopic;
    }

    public synchronized Topic getLogTopic() {
        if (this.logTopic == null) {
            this.getTopicSession();
        }
        return this.logTopic;
    }

    public MessageProducer getCommandPublisher(Session sess) {
        try {
            return sess.createProducer((Destination)this.commandTopic);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public MessageProducer getStatusPublisher(Session sess) {
        try {
            return sess.createProducer((Destination)this.statusTopic);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public MessageProducer getLogPublisher(Session sess) {
        try {
            return sess.createProducer((Destination)this.logTopic);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public MessageConsumer getCommandSubscriber(Session sess) {
        try {
            return sess.createConsumer((Destination)this.commandTopic, null, true);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public MessageConsumer getCommandSubscriber(Session sess, String messageSelector) {
        try {
            return sess.createConsumer((Destination)this.commandTopic, messageSelector, true);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public MessageConsumer getStatusSubscriber(Session sess) {
        try {
            return sess.createConsumer((Destination)this.statusTopic, null, true);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public MessageConsumer getStatusSubscriber(Session sess, String messageSelector) {
        try {
            return sess.createConsumer((Destination)this.statusTopic, messageSelector, true);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public MessageConsumer getLogSubscriber(Session sess, String messageSelector) {
        try {
            return sess.createConsumer((Destination)this.logTopic, messageSelector, true);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public MessageProducer getCommandReplyPublisher(Session sess, Destination dest) {
        try {
            return sess.createProducer(dest);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

