package org.lsst.ccs.bus.jms;

import org.lsst.ccs.framework.FrameworkUtils;
import org.lsst.ccs.utilities.logging.Logger;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Properties;

/**
 * JMS Queue session factory
 * 
 * @author aubourg
 * 
 */

public class QueueSessionFactory {
	static protected QueueSessionFactory instance = null;

	public static synchronized QueueSessionFactory getSessionFactory() {
		if (instance == null) {
			instance = new QueueSessionFactory();
		}
		return instance;
	}

	static Logger log = Logger.getLogger("lsst.ccs.bus.QueueSessionFactory");

	Connection conn;

	Context context;

	ConnectionFactory cf;

	public Session getQueueSession() {
		try {
			if (context == null) {
                            Properties props = FrameworkUtils.loadProperties(FrameworkUtils.getDefaultJndiProperties(),this.getClass(), "jndi.properties");
                            context = new InitialContext(props);
			}
			if (cf == null) {
				cf = (ConnectionFactory) context.lookup("ConnectionFactory");
			}
			if (conn == null) {
				conn = cf.createConnection();
				conn.start();
			}

			Session session = conn.createSession(false,
					Session.AUTO_ACKNOWLEDGE);

			return session;
		} catch (NamingException e1) {
			e1.printStackTrace();
			throw new RuntimeException(e1);
		} catch (JMSException e2) {
			e2.printStackTrace();
			throw new RuntimeException(e2);
		}
	}

	public MessageProducer getCommandReplySender(Session sess, Destination dest) {
		try {
			return sess.createProducer(dest);
		} catch (JMSException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

}
