/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jms;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.log4j.Logger;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.LogListener;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.PriorityLevel;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.jms.QueueSessionFactory;
import org.lsst.ccs.bus.jms.TopicSessionFactory;

public class JMSMessagingFactory
extends MessagingFactory {
    ThreadLocal<String> localCorrelID = new ThreadLocal();
    ThreadLocal<Destination> localReplyTo = new ThreadLocal();
    ThreadLocal<String> localOrigin = new ThreadLocal();
    ThreadLocal<Command> localCommand = new ThreadLocal();
    String token = UUID.randomUUID().toString();
    protected static Logger log = Logger.getLogger((String)"lsst.ccs.JMSMessagingFactory");
    ExecutorService exec = Executors.newFixedThreadPool(5);
    MessageListener commandMessageListener;

    public String getToken() {
        return this.token;
    }

    public void addCommandListener(CommandListener l) {
        this.addCommandListener(l, null);
    }

    public void addCommandListener(final CommandListener l, String selector) {
        log.debug((Object)("adding command listener, selector='" + selector + "'"));
        Session session = TopicSessionFactory.getSessionFactory().getTopicSession();
        MessageConsumer sub = selector == null ? TopicSessionFactory.getSessionFactory().getCommandSubscriber(session) : TopicSessionFactory.getSessionFactory().getCommandSubscriber(session, selector);
        try {
            MessageListener ml = new MessageListener(){

                public void onMessage(Message msg) {
                    if (msg instanceof ObjectMessage) {
                        log.debug((Object)"MessageListener got jms message on command");
                        MessageHandler mh = new MessageHandler((ObjectMessage)msg, l);
                        JMSMessagingFactory.this.exec.execute(mh);
                    } else {
                        log.warn((Object)("Message  type " + msg.getClass().getName() + " not handled " + msg));
                    }
                }
            };
            sub.setMessageListener(ml);
            this.commandMessageListener = ml;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public void addStatusListener(StatusListener l) {
        this.addStatusListener(l, null);
    }

    public void addStatusListener(final StatusListener l, String selector) {
        log.debug((Object)("adding status listener, selector='" + selector + "'"));
        Session session = TopicSessionFactory.getSessionFactory().getTopicSession();
        MessageConsumer sub = TopicSessionFactory.getSessionFactory().getStatusSubscriber(session, selector);
        MessageListener ml = new MessageListener(){

            public void onMessage(Message msg) {
                if (msg instanceof ObjectMessage) {
                    Serializable payload;
                    log.debug((Object)"MessageListener got jms message on status");
                    try {
                        payload = ((ObjectMessage)msg).getObject();
                    }
                    catch (JMSException e) {
                        log.error((Object)"Got Object Message, could not deserialize: missing class?", (Throwable)e);
                        return;
                    }
                    if (payload instanceof Status) {
                        l.onStatus((BusMessage)payload);
                    } else {
                        log.warn((Object)("Message payload type " + payload.getClass().getName() + " not handled " + payload));
                    }
                } else {
                    log.warn((Object)("Message  type " + msg.getClass().getName() + " not handled " + msg));
                }
            }
        };
        try {
            sub.setMessageListener(ml);
        }
        catch (JMSException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void addLogListener(LogListener l) {
        this.addLogListener(l, null);
    }

    public void addLogListener(final LogListener l, String selector) {
        log.debug((Object)("adding log listener, selector='" + selector + "'"));
        Session session = TopicSessionFactory.getSessionFactory().getTopicSession();
        MessageConsumer sub = TopicSessionFactory.getSessionFactory().getLogSubscriber(session, selector);
        MessageListener ml = new MessageListener(){

            public void onMessage(Message msg) {
                if (msg instanceof ObjectMessage) {
                    Serializable payload;
                    log.debug((Object)"MessageListener got jms message on log");
                    try {
                        payload = ((ObjectMessage)msg).getObject();
                    }
                    catch (JMSException e) {
                        throw new RuntimeException(e);
                    }
                    if (payload instanceof LogEvent) {
                        l.onLog((LogEvent)payload);
                    } else {
                        log.warn((Object)("Message payload type " + payload.getClass().getName() + " not handled " + payload));
                    }
                } else {
                    log.warn((Object)("Message  type " + msg.getClass().getName() + " not handled " + msg));
                }
            }
        };
        try {
            sub.setMessageListener(ml);
        }
        catch (JMSException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void sendCommand(Command cmd) {
        cmd.setKey(this.token);
        if (null == cmd.getOrigin()) {
            cmd.setOrigin(MessagingFactory.getInstance().getSubsystemName());
        }
        if (cmd.getCorrelId() == null) {
            cmd.setCorrelId(this.localCorrelID.get());
        }
        if (cmd.getCorrelId() == null) {
            cmd.setCorrelId(UUID.randomUUID().toString());
        }
        Session sess = TopicSessionFactory.getSessionFactory().getTopicSession();
        MessageProducer send = TopicSessionFactory.getSessionFactory().getCommandPublisher(sess);
        try {
            ObjectMessage m = sess.createObjectMessage();
            m.setObject((Serializable)cmd);
            m.setJMSType(cmd.getMessageType());
            m.setStringProperty("destination", cmd.getDestination());
            m.setJMSPriority(JMSMessagingFactory.convertToJMSPriority(cmd.getPriorityLevel()));
            if (cmd.getCorrelId() != null) {
                m.setJMSCorrelationID(cmd.getCorrelId());
            }
            log.debug((Object)("sending command " + cmd));
            this.sendMessage(m, sess, send);
            sess.close();
        }
        catch (JMSException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static int convertToJMSPriority(PriorityLevel level) {
        switch (level) {
            case DEBUG: {
                return 0;
            }
            case INFO: {
                return 4;
            }
            case OPERATION: {
                return 5;
            }
            case CRITICAL: {
                return 9;
            }
        }
        return 4;
    }

    public void sendStatus(Status s) {
        if (null == s.getOrigin()) {
            s.setOrigin(MessagingFactory.getInstance().getSubsystemName());
        }
        Session sess = TopicSessionFactory.getSessionFactory().getTopicSession();
        MessageProducer send = TopicSessionFactory.getSessionFactory().getStatusPublisher(sess);
        try {
            ObjectMessage m = sess.createObjectMessage();
            m.setObject((Serializable)s);
            m.setJMSType(s.getMessageType());
            m.setJMSTimestamp(System.currentTimeMillis());
            m.setJMSPriority(JMSMessagingFactory.convertToJMSPriority(s.getPriorityLevel()));
            m.setStringProperty("destination", "*");
            log.debug((Object)("sending status " + s));
            this.sendMessage(m, sess, send);
            sess.close();
        }
        catch (JMSException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void sendLogEvent(LogEvent evt) {
        Session sess = TopicSessionFactory.getSessionFactory().getTopicSession();
        MessageProducer send = TopicSessionFactory.getSessionFactory().getLogPublisher(sess);
        try {
            ObjectMessage m = sess.createObjectMessage();
            m.setObject((Serializable)evt);
            m.setJMSType(evt.getMessageType());
            m.setStringProperty("destination", "*");
            m.setJMSPriority(JMSMessagingFactory.convertToJMSPriority(evt.getPriorityLevel()));
            log.debug((Object)("sending log " + evt));
            this.sendMessage(m, sess, send);
            sess.close();
        }
        catch (JMSException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected void sendMessage(ObjectMessage m, Session sess, MessageProducer sender) {
        try {
            if (m.getJMSCorrelationID() == null) {
                m.setJMSCorrelationID(this.localCorrelID.get());
            }
            m.setJMSMessageID("0");
            m.setJMSPriority(4);
            m.setJMSReplyTo((Destination)TopicSessionFactory.getSessionFactory().getCommandTopic());
            m.setJMSTimestamp(System.currentTimeMillis());
            sender.send((Message)m);
            sender.close();
        }
        catch (JMSException e) {
            log.error((Object)"Error sending message", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                sess.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS session", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isReplyRequested() {
        return this.localReplyTo.get() != null;
    }

    public void noAutoReply() {
        this.localReplyTo.set(null);
    }

    public void reply(CommandAckOrReply reply) {
        Destination dest = this.localReplyTo.get();
        String destSystem = this.localOrigin.get();
        if (reply.getCorrelId() == null) {
            reply.setCorrelId(this.localCorrelID.get());
        }
        reply.setOriginalCommand(this.localCommand.get());
        if (null == reply.getOrigin()) {
            reply.setOrigin(MessagingFactory.getInstance().getSubsystemName());
        }
        log.debug((Object)("sending reply " + reply + " to " + dest + "[" + destSystem + "]"));
        if (dest instanceof Queue) {
            Session sess = QueueSessionFactory.getSessionFactory().getQueueSession();
            MessageProducer sender = QueueSessionFactory.getSessionFactory().getCommandReplySender(sess, dest);
            try {
                ObjectMessage m = sess.createObjectMessage();
                m.setObject((Serializable)reply);
                if (reply instanceof CommandReply) {
                    m.setJMSType("lsst.commandreply");
                } else {
                    m.setJMSType("lsst.commandack");
                }
                m.setStringProperty("destination", destSystem);
                m.setJMSCorrelationID(reply.getCorrelId());
                sender.send((Message)m);
                sender.close();
                sess.close();
            }
            catch (JMSException e) {
                log.error((Object)e);
            }
        } else {
            Session sess = TopicSessionFactory.getSessionFactory().getTopicSession();
            MessageProducer sender = TopicSessionFactory.getSessionFactory().getCommandReplyPublisher(sess, dest);
            try {
                ObjectMessage m = sess.createObjectMessage();
                m.setObject((Serializable)reply);
                if (reply instanceof CommandReply) {
                    m.setJMSType("lsst.commandreply");
                } else {
                    m.setJMSType("lsst.commandack");
                }
                m.setStringProperty("destination", destSystem);
                m.setJMSCorrelationID(reply.getCorrelId());
                sender.send((Message)m);
                sender.close();
                sess.close();
            }
            catch (JMSException e) {
                log.error((Object)e);
            }
        }
    }

    class MessageHandler
    implements Runnable {
        ObjectMessage msg;
        CommandListener l;

        public MessageHandler(ObjectMessage msg, CommandListener l) {
            this.msg = msg;
            this.l = l;
        }

        @Override
        public void run() {
            try {
                Serializable payload = this.msg.getObject();
                if (payload instanceof Command) {
                    JMSMessagingFactory.this.localCorrelID.set(this.msg.getJMSCorrelationID());
                    JMSMessagingFactory.this.localReplyTo.set(this.msg.getJMSReplyTo());
                    JMSMessagingFactory.this.localOrigin.set(((Command)payload).getOrigin());
                    JMSMessagingFactory.this.localCommand.set((Command)payload);
                    this.l.onCommand((Command)payload);
                } else if (payload instanceof CommandReply) {
                    JMSMessagingFactory.this.localCorrelID.set(this.msg.getJMSCorrelationID());
                    JMSMessagingFactory.this.localReplyTo.set(null);
                    JMSMessagingFactory.this.localOrigin.set(null);
                    this.l.onReply((CommandReply)payload);
                } else if (payload instanceof CommandAck) {
                    JMSMessagingFactory.this.localCorrelID.set(this.msg.getJMSCorrelationID());
                    JMSMessagingFactory.this.localReplyTo.set(null);
                    JMSMessagingFactory.this.localOrigin.set(null);
                    this.l.onAck((CommandAck)payload);
                } else {
                    log.warn((Object)("Message payload type " + payload.getClass().getName() + " not handled " + payload));
                }
            }
            catch (JMSException e) {
                log.error((Object)"Problem receiving message, class not handled?", (Throwable)e);
            }
        }
    }
}

