/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.io.InputStream;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

public class GroupsTest6 {
    public static void main(String[] args) throws Exception {
        InputStream stream = BootstrapResourceUtils.getBootstrapResource((String)"udp.xml", GroupsTest6.class);
        JChannel channelX = new JChannel(stream);
        channelX.setName("subsystem X");
        channelX.connect("busA");
        Address addressX = channelX.getAddress();
        JChannel channelSNOOP = new JChannel(stream);
        channelSNOOP.setName("snoop");
        channelSNOOP.connect("busA");
        Address addressSNOOP = channelSNOOP.getAddress();
        JChannel channelSNOOP2 = new JChannel(stream);
        channelSNOOP2.setName("snoop");
        channelSNOOP2.connect("busA");
        channelX.setReceiver((Receiver)new MyReceiver("subsystem X"));
        channelSNOOP.setReceiver((Receiver)new MyReceiver("snoop"));
        channelSNOOP2.setReceiver((Receiver)new MyReceiver("snoop2"));
        View view = channelSNOOP.getView();
        for (Object obj : view.getMembers()) {
            System.out.println(" viewing :" + obj + " [" + obj.getClass() + " ]" + obj.hashCode());
        }
        Thread.sleep(1000L);
        channelX.send(null, (Object)"for ALL A");
        channelX.send(addressX, (Object)"for X  on A");
        channelX.send(addressSNOOP, (Object)"for snoop");
        Thread.sleep(5000L);
        channelX.close();
        channelSNOOP.close();
        channelSNOOP2.close();
    }

    public static class MyReceiver
    implements Receiver {
        String name;

        public MyReceiver(String name) {
            this.name = name;
        }

        public void viewAccepted(View new_view) {
        }

        public void receive(Message msg) {
            System.out.println(this.name + " <<< " + msg.getSrc() + ": " + msg.getObject());
        }
    }
}

