package org.lsst.ccs.messaging.jgroups;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jgroups.tests.Probe;
import org.lsst.ccs.bus.definition.Bus;

/**
 * A utility class to split clusters.
 *
 * @author The LSST CCS Team
 */
public class ClusterSplitUtils {

    public static Set<String>[] splitCluster(int nSplits, Set<String> allAgents) {

        Set<String>[] splits;
        splits = new HashSet[nSplits];
        for (int i = 0; i < nSplits; i++) {
            splits[i] = new HashSet<>();
        }

        //Fill the splits
        Iterator<String> iter = allAgents.iterator();
        int count = 0;
        while (iter.hasNext()) {
            splits[count % nSplits].add(iter.next());
            count++;
        }

        for (int i = 0; i < nSplits; i++) {
            String newView = "";
            String splitMembers = "";
            for (String member : splits[i]) {
                if (!splitMembers.isEmpty()) {
                    splitMembers += "/";
                }
                splitMembers += JGroupsBusMessagingLayer.getBusNameForAgent(member, Bus.STATUS);
            }

            for (String member : splits[i]) {
                if (!newView.isEmpty()) {
                    newView += ";";
                }
                newView += JGroupsBusMessagingLayer.getBusNameForAgent(member, Bus.STATUS) + "=" + splitMembers;
            }

            ArrayList<String> args = new ArrayList<>();
            args.add("op=INJECT_VIEW.injectView[\"" + newView + "\"]");
            System.out.println("Injecting view with Probe: " + args);
            try {
                Probe.main(args.toArray(new String[0]));
            } catch (Exception e) {
                throw new RuntimeException(e);
            }

        }

        return splits;

    }

}
