package org.lsst.ccs.messaging.jgroups;

import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.TransportManager;


/**
 */
public class JGroupsTransportManager extends TransportManager {

    /**
     * Constructs an instance of {@code MessagingLayer}.
     * 
     * @param protocolString Protocol selection and configuration string in 
     *                       {@code jgroups[:configuration_file_name[:dispatcher_configuration]}
     *                       format.
     * @param propertiesString Additional {@code Dispatcher} configuration string. Ignored unless {@code protocolString} contains
     *                         {@code Dispatcher} class name but no configuration for it. Otherwise, appended after "?".
     * @return Instance of {@code MessagingLayer}, or {@code null} if {@code protocolString} does not start with "jgroups".
     */
    @Override
    public BusMessagingLayer getInstance(String protocolString, String propertiesString) {

        if (protocolString.startsWith("jgroups")) {
            
            if ("jgroups".equals(protocolString)) {
                protocolString = JGroupsBusMessagingLayer.DEFAULT_UDP_PROTOCOL;
            }
            
            propertiesString = propertiesString.trim();
            if (!propertiesString.isEmpty()) {
                String[] protocolStringTokens = protocolString.split(":");
                if (protocolStringTokens.length == 3 && !protocolStringTokens[2].contains("?")) {
                    protocolString = protocolString +"?"+ propertiesString;
                }
            }
            
            JGroupsBusMessagingLayer layer = new JGroupsBusMessagingLayer(protocolString);
            return layer;
        } else {
            return null;
        }
    }

    String getKey(String protocolString, String propertiesString) {
        //just in case
        String props = propertiesString.replace('\n', ';');
        return props.replaceAll("\\s", "");
    }
}
