/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.stack.AddressGenerator;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.ClusterMembershipListener;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.HasClusterMembershipNotifications;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.messaging.jgroups.CCSAddress;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class JGroupsBusMessagingLayer
implements BusMessagingLayer,
HasClusterMembershipNotifications {
    public static final String DEFAULT_UDP_PROTOCOL = "jgroups:udp_ccs";
    public static final String DEFAULT_DISPATCHER = "org.lsst.ccs.messaging.util.MultiQueueDispatcher";
    private final Properties jgroupsProperties;
    private String xmlConfigurationFile = "udp_ccs.xml";
    private static final String propertyKeyForJGroups = "org.lsst.ccs.jgroups.";
    private static final String propertyKeyForAllBuses = "org.lsst.ccs.jgroups.ALL.";
    private static final Logger logger = Logger.getLogger((String)"org.lsst.ccs.messaging.jgroups");
    private volatile String agentName;
    private final EnumMap<Bus, CCSBusHandler> busHandlers = new EnumMap(Bus.class);
    private final List<ClusterMembershipListener> clusterMembershipListeners = new CopyOnWriteArrayList<ClusterMembershipListener>();
    private final Dispatcher dispatcher;

    JGroupsBusMessagingLayer(String protocolString) {
        String[] protocolInfos = protocolString.split(":");
        String rawResource = protocolInfos[1];
        if (rawResource.length() > 0) {
            this.xmlConfigurationFile = String.format("/%s.xml", rawResource);
        }
        String propertiesConfigurationFile = this.xmlConfigurationFile.replace(".xml", ".properties");
        this.jgroupsProperties = BootstrapResourceUtils.getBootstrapProperties((String)propertiesConfigurationFile, this.getClass());
        String sysPref = "system.property.";
        for (String key : this.jgroupsProperties.stringPropertyNames()) {
            String shortKey;
            if (!key.startsWith(sysPref) || System.getProperty(shortKey = key.substring(sysPref.length())) != null) continue;
            System.setProperty(shortKey, this.jgroupsProperties.getProperty(key));
        }
        String mps = protocolInfos.length > 2 && !protocolInfos[2].trim().isEmpty() ? protocolInfos[2] : DEFAULT_DISPATCHER;
        String[] mpsPar = mps.split("\\?");
        String[] constructorParameters = mpsPar.length > 1 ? mpsPar[1].split("\\&") : new String[]{};
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(mpsPar[0]);
            this.dispatcher = (Dispatcher)clazz.getConstructor(String[].class).newInstance(new Object[]{constructorParameters});
            StringBuilder sb = new StringBuilder();
            sb.append("Message Dispatcher: ").append(this.dispatcher.getClass().getSimpleName()).append("\n");
            if (constructorParameters.length > 0) {
                sb.append("Parameters:\n");
                for (String s : constructorParameters) {
                    sb.append(s);
                }
            }
            logger.fine((Object)sb.toString());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException x) {
            logger.error((Object)"Failed to initialize message Dispatcher", (Throwable)x);
            throw new RuntimeException(x);
        }
    }

    static XmlConfigurator createXmlConfiguratorForBus(String xmlConfigurationFile, Properties properties, String bus) {
        String[] propertyKeys;
        InputStream xmlConfigurationFileInputStream = BootstrapResourceUtils.getBootstrapResource((String)xmlConfigurationFile, JGroupsBusMessagingLayer.class);
        if (xmlConfigurationFileInputStream == null) {
            throw new IllegalArgumentException(xmlConfigurationFile + " not found as a resource");
        }
        XmlConfigurator configurator = null;
        try {
            configurator = XmlConfigurator.getInstance((InputStream)xmlConfigurationFileInputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create JGroups xml configuration object for " + xmlConfigurationFile, ioe);
        }
        List protocolConfigurationList = configurator.getProtocolStack();
        for (String propertyKey : propertyKeys = new String[]{propertyKeyForAllBuses, propertyKeyForJGroups + bus.toUpperCase() + "."}) {
            Set keys = BootstrapResourceUtils.getAllKeysInProperties((Properties)properties);
            for (Object key : keys) {
                String property = (String)key;
                if (!property.startsWith(propertyKey)) continue;
                String shortProperty = property.replace(propertyKey, "");
                int divider = shortProperty.lastIndexOf(".");
                String protocolPropertyName = shortProperty.substring(divider + 1);
                String protocolName = shortProperty.substring(0, divider);
                String protocolPropertyValue = properties.getProperty(property);
                boolean found = false;
                for (ProtocolConfiguration protocolConfiguration : protocolConfigurationList) {
                    if (!protocolConfiguration.getProtocolName().equals(protocolName)) continue;
                    protocolConfiguration.getProperties().put(protocolPropertyName, protocolPropertyValue);
                    found = true;
                    break;
                }
                if (found) continue;
                HashMap<String, String> hash = new HashMap<String, String>();
                if (!"add".equalsIgnoreCase(protocolPropertyName) || !"true".equalsIgnoreCase(protocolPropertyValue)) {
                    hash.put(protocolPropertyName, protocolPropertyValue);
                }
                ProtocolConfiguration newProtocol = new ProtocolConfiguration(protocolName, hash);
                protocolConfigurationList.add(newProtocol);
            }
        }
        return configurator;
    }

    public void close() throws IOException {
        this.dispatcher.shutdown();
        for (CCSBusHandler bh : this.busHandlers.values()) {
            bh.close();
        }
    }

    public void connect(MessagingAccessLayer accessLayer) throws DuplicateAgentNameException, IOException {
        logger.fine((Object)("### Registering " + accessLayer.getName() + " on the buses"));
        this.agentName = accessLayer.getName();
        if (this.agentName == null || "".equals(this.agentName)) {
            throw new IllegalArgumentException("Invalid agent name " + this.agentName);
        }
        this.dispatcher.initialize();
        for (MessagingAccessLayer.BusAccess ba : accessLayer.getBusAccesses()) {
            Bus bus = ba.getBus();
            try {
                XmlConfigurator configurator = JGroupsBusMessagingLayer.createXmlConfiguratorForBus(this.xmlConfigurationFile, this.jgroupsProperties, bus.toString());
                JChannel channel = new JChannel((ProtocolStackConfigurator)configurator);
                logger.fine((Object)("######################################################\nJGroup Configuration for bus: " + bus.toString() + "\n" + channel.getProtocolStack().printProtocolSpecAsXML() + "\n######################################################"));
                channel.setName(this.agentName);
                String disable_rank = System.getProperty("ccs.jg.disable_rank");
                if (!"true".equalsIgnoreCase(disable_rank)) {
                    channel.addAddressGenerator((AddressGenerator)new CCSAddress.Generator(accessLayer.getAgentInfo()));
                }
                channel.connect(bus.toString());
                View view = channel.getView();
                if (this.isDuplicate(view, channel.getAddress())) {
                    channel.close();
                    throw new DuplicateAgentNameException(this.agentName, "Channel with same name already exists in view");
                }
                String[] propertiesArray = channel.getProperties().split(";");
                String bind_addr = null;
                for (int i = 0; i < propertiesArray.length; ++i) {
                    if (!propertiesArray[i].startsWith("bind_addr=")) continue;
                    bind_addr = propertiesArray[i];
                    break;
                }
                logger.fine((Object)("*** new view " + channel.getClusterName() + " " + view + " " + bind_addr));
                CCSBusHandler bh = new CCSBusHandler(ba, channel, bus);
                bh.getBusHandler().viewAccepted(view);
                this.busHandlers.put(bus, bh);
                channel.setReceiver((Receiver)bh.getBusHandler());
                bh.open();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void disconnect(MessagingAccessLayer accessLayers) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean hasInternalHeartbeat() {
        return true;
    }

    public void addClusterMembershipListener(ClusterMembershipListener listener) {
        this.clusterMembershipListeners.add(listener);
    }

    public void removeClusterMembershipListener(ClusterMembershipListener listener) {
        this.clusterMembershipListeners.remove(listener);
    }

    public <T extends BusMessage> void sendMessage(String senderAgent, Bus bus, T message) {
        this.busHandlers.get(bus).waitForOpen();
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        this.busHandlers.get(bus).getBusHandler().send(message);
    }

    public Set<String> getRegisteredLocalAgents(Bus ... buses) {
        return this.agentName == null ? Collections.emptySet() : Collections.singleton(this.agentName);
    }

    private boolean isDuplicate(View view, Address address) {
        for (Address a : view.getMembers()) {
            if (address.equals(a) || !a.toString().equals(address.toString())) continue;
            return true;
        }
        return false;
    }

    public static Logger getLogger() {
        return logger;
    }

    public void register(String agentName, Bus ... buses) throws IOException, DuplicateAgentNameException {
    }

    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        throw new UnsupportedOperationException("BusMessagingLayer called");
    }

    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        throw new UnsupportedOperationException("BusMessagingLayer called");
    }

    public void closeFor(String agentName, Bus ... buses) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class CCSBusHandler {
        private final BusHandler busHandler;
        private volatile Boolean isOpen;
        private final Object openLock = new Object();
        private final Bus bus;

        CCSBusHandler(MessagingAccessLayer.BusAccess ba, JChannel ch, Bus bus) {
            this.busHandler = new BusHandler(ba, ch);
            this.bus = bus;
        }

        BusHandler getBusHandler() {
            return this.busHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open() {
            Object object = this.openLock;
            synchronized (object) {
                this.isOpen = Boolean.TRUE;
                this.openLock.notify();
            }
        }

        void close() {
            this.isOpen = Boolean.FALSE;
            this.busHandler.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForOpen() {
            if (this.isOpen.booleanValue()) {
                return;
            }
            Object object = this.openLock;
            synchronized (object) {
                if (!this.isOpen.booleanValue()) {
                    throw new TransportStateException("JGroups bus " + this.bus + " not connected");
                }
                if (this.isOpen == null) {
                    try {
                        this.openLock.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                }
            }
        }
    }

    private class BusHandler
    extends ReceiverAdapter {
        private final JChannel channel;
        private final MessagingAccessLayer.BusAccess accessLayer;
        private volatile View lastView;

        BusHandler(MessagingAccessLayer.BusAccess accessLayer, JChannel chan) {
            this.accessLayer = accessLayer;
            this.channel = chan;
            this.lastView = new View(this.channel.getAddress(), 0L, Collections.singletonList(this.channel.getAddress()));
        }

        public void receive(Message message) {
            Object o;
            final String agent = message.getSrc().toString();
            try {
                o = (BusMessage)message.getObject();
            }
            catch (RuntimeException x) {
                o = x;
            }
            final Object payload = o;
            Dispatcher.Task task = new Dispatcher.Task(){

                public void stageEnded(Dispatcher.Stage ... stages) {
                    block4: for (Dispatcher.Stage stage : stages) {
                        switch (stage) {
                            case START: {
                                if (!(payload instanceof BusMessage)) continue block4;
                                ((BusMessage)payload).setIncomingQueueInTimeStamp(CCSTimeStamp.currentTime());
                                continue block4;
                            }
                            case WAIT: {
                                if (!(payload instanceof BusMessage)) continue block4;
                                ((BusMessage)payload).setIncomingQueueOutTimeStamp(CCSTimeStamp.currentTime());
                            }
                        }
                    }
                }

                public void run() {
                    if (payload instanceof BusMessage) {
                        BusHandler.this.accessLayer.processBusMessage((BusMessage)payload);
                    } else {
                        RuntimeException ex = (RuntimeException)payload;
                        if (payload == null) {
                            ex = new RuntimeException("Null payload! This could be due to inconsistent communication protocols.");
                        }
                        BusHandler.this.accessLayer.processClusterDeserializationError(agent, ex);
                    }
                }
            };
            JGroupsBusMessagingLayer.this.dispatcher.in((Runnable)task, this.getBus(), new String[]{agent});
        }

        public void viewAccepted(View view) {
            logger.fine((Object)(this.accessLayer.getBus() + " view accepted : " + view.getMembers()));
            boolean isMerge = view instanceof MergeView;
            long deltaId = Math.abs(view.getViewId().getId() - this.lastView.getViewId().getId());
            boolean needsClusterReset = isMerge && deltaId > 1L;
            List leftMembers = View.leftMembers((View)this.lastView, (View)view);
            List joinedMembers = View.newMembers((View)this.lastView, (View)view);
            if (this.getBus() == Bus.STATUS && needsClusterReset) {
                leftMembers.addAll(this.lastView.getMembers());
                leftMembers.remove(this.channel.getAddress());
                joinedMembers.addAll(leftMembers);
                logger.fine((Object)("Cluster Reset for agent" + this.channel.getAddressAsString() + " new joined members : " + joinedMembers));
            }
            this.lastView = view;
            int nConnected = joinedMembers.size();
            int nDisconnected = leftMembers.size();
            if (this.getBus() == Bus.STATUS) {
                if (nDisconnected > 0) {
                    ArrayList<String> disconnectedAgents = new ArrayList<String>(nDisconnected);
                    for (Address address : leftMembers) {
                        disconnectedAgents.add(address.toString());
                    }
                    logger.fine((Object)("Firing notification of cluster disconnection: ====== " + disconnectedAgents));
                    JGroupsBusMessagingLayer.this.dispatcher.in(() -> {
                        for (ClusterMembershipListener l : JGroupsBusMessagingLayer.this.clusterMembershipListeners) {
                            try {
                                l.membersLeft((List)disconnectedAgents);
                            }
                            catch (Exception x) {
                                logger.warn((Object)"Exception while notifying listeners of agent disconnection", (Throwable)x);
                            }
                        }
                    }, this.getBus(), disconnectedAgents.toArray(new String[0]));
                }
                if (nConnected > 0) {
                    ArrayList<String> connectedAgents = new ArrayList<String>(nConnected);
                    for (Address address : joinedMembers) {
                        connectedAgents.add(address.toString());
                    }
                    logger.fine((Object)("Firing notification of cluster connection: ====== " + connectedAgents));
                    JGroupsBusMessagingLayer.this.dispatcher.in(() -> {
                        for (ClusterMembershipListener l : JGroupsBusMessagingLayer.this.clusterMembershipListeners) {
                            try {
                                l.membersJoined((List)connectedAgents);
                            }
                            catch (Exception x) {
                                logger.warn((Object)"Exception while notifying listeners of agent connection", (Throwable)x);
                            }
                        }
                    }, this.getBus(), connectedAgents.toArray(new String[0]));
                }
            }
            logger.fine((Object)("Updated current view : " + this.lastView.getMembers()));
        }

        void close() {
            this.channel.close();
        }

        void send(final BusMessage message) {
            Dispatcher.Task task = new Dispatcher.Task(){

                public void stageEnded(Dispatcher.Stage ... stages) {
                    block4: for (Dispatcher.Stage stage : stages) {
                        switch (stage) {
                            case START: {
                                message.setOutgoingQueueInTimeStamp(CCSTimeStamp.currentTime());
                                continue block4;
                            }
                            case WAIT: {
                                message.setOutgoingQueueOutTimeStamp(CCSTimeStamp.currentTime());
                            }
                        }
                    }
                }

                public void run() {
                    try {
                        BusHandler.this.channel.send(null, (Object)message);
                    }
                    catch (Exception exc) {
                        throw new RuntimeException("Failed sending message " + message.getClass().getCanonicalName() + " with data " + message.getClassName(), exc);
                    }
                }
            };
            JGroupsBusMessagingLayer.this.dispatcher.out((Runnable)task, this.getBus(), Dispatcher.Order.NORM);
        }

        Bus getBus() {
            return this.accessLayer.getBus();
        }
    }
}

