/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.util.Properties;
import java.util.Set;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.messaging.jgroups.JGroupsBusMessagingLayer;

public class PringJGroupsThreads {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testOneChannelThreads() throws Exception {
        String xmlConfigurationFile = "udp_ccs.xml";
        String propertiesConfigurationFile = xmlConfigurationFile.replace(".xml", ".properties");
        Properties jgroupsProperties = BootstrapResourceUtils.getBootstrapProperties((String)propertiesConfigurationFile, this.getClass());
        int threadCount = 1;
        for (Bus b : Bus.values()) {
            XmlConfigurator configurator = JGroupsBusMessagingLayer.createXmlConfiguratorForBus((String)xmlConfigurationFile, (Properties)jgroupsProperties, (String)b.toString());
            JChannel channel = new JChannel((ProtocolStackConfigurator)configurator);
            channel.setName("testChannel");
            channel.connect(b.toString());
            threadCount += 10;
            for (int i = 0; i < 50; ++i) {
                channel.send(new Message());
            }
            threadCount += 2;
            channel.setReceiver((Receiver)new TestBusReceiver());
        }
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread t : threadSet) {
            System.out.println("*** " + t.getName());
        }
        double threadsPerChannel = (double)(Thread.activeCount() - 1) / 3.0;
        int baseline = Thread.activeCount();
        System.out.println("Threads: " + Thread.activeCount() + " " + threadsPerChannel);
        for (Bus b : Bus.values()) {
            XmlConfigurator configurator = JGroupsBusMessagingLayer.createXmlConfiguratorForBus((String)xmlConfigurationFile, (Properties)jgroupsProperties, (String)b.toString());
            JChannel channel = new JChannel((ProtocolStackConfigurator)configurator);
            channel.setName("testChannel");
            channel.connect(b.toString());
            threadCount += 10;
            System.out.println("Threads: " + Thread.activeCount());
            for (int i = 0; i < 50; ++i) {
                channel.send(new Message());
            }
            threadCount += 2;
            System.out.println("Threads: " + Thread.activeCount());
            channel.setReceiver((Receiver)new TestBusReceiver());
        }
        threadsPerChannel = (double)(Thread.activeCount() - baseline) / 3.0;
        System.out.println("Threads: " + Thread.activeCount() + " " + threadsPerChannel);
    }

    private class TestBusReceiver
    extends ReceiverAdapter {
        private TestBusReceiver() {
        }

        public void receive(Message message) {
        }
    }
}

